/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.infonode.gui.icon.IconUtil;

public class TextIconListCellRenderer
extends DefaultListCellRenderer {
    private ListCellRenderer renderer;
    private Icon emptyIcon;
    private int width;
    private int gap = -1;

    public TextIconListCellRenderer(ListCellRenderer listCellRenderer) {
        this.renderer = listCellRenderer;
    }

    public void calculateMaximumIconWidth(Object[] objectArray) {
        this.width = IconUtil.getMaxIconWidth(objectArray);
        this.emptyIcon = this.width == 0 ? null : new Icon(){

            public int getIconHeight() {
                return 1;
            }

            public int getIconWidth() {
                return TextIconListCellRenderer.this.width;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            }
        };
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        this.renderer = listCellRenderer;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Icon icon;
        if (n == -1) {
            return null;
        }
        JLabel jLabel = (JLabel)this.renderer.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (this.gap < 0) {
            this.gap = jLabel.getIconTextGap();
        }
        if ((icon = IconUtil.getIcon(object)) == null) {
            jLabel.setIcon(this.emptyIcon);
        } else {
            jLabel.setIcon(icon);
            jLabel.setIconTextGap(this.gap + this.width - icon.getIconWidth());
        }
        return jLabel;
    }
}

