/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.location;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.location.LocationDecoder;
import net.infonode.docking.location.WindowLocation;
import net.infonode.util.IntList;

public abstract class AbstractWindowLocation
implements WindowLocation {
    private WindowLocation parentLocation;
    private WeakReference window;

    protected abstract boolean set(DockingWindow var1, DockingWindow var2);

    protected AbstractWindowLocation(DockingWindow dockingWindow, WindowLocation windowLocation) {
        this.window = new WeakReference<DockingWindow>(dockingWindow);
        this.parentLocation = windowLocation;
    }

    protected AbstractWindowLocation() {
    }

    public boolean set(DockingWindow dockingWindow) {
        DockingWindow dockingWindow2 = this.getWindow();
        if (dockingWindow2 != null) {
            this.set(dockingWindow2, dockingWindow);
        } else if (this.parentLocation != null) {
            this.parentLocation.set(dockingWindow);
        }
        return true;
    }

    private DockingWindow getWindow() {
        if (this.window == null) {
            return null;
        }
        DockingWindow dockingWindow = (DockingWindow)this.window.get();
        return dockingWindow != null && dockingWindow.getRootWindow() != null && !dockingWindow.isMinimized() ? dockingWindow : null;
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        DockingWindow dockingWindow;
        objectOutputStream.writeBoolean(this.parentLocation != null);
        if (this.parentLocation != null) {
            this.parentLocation.write(objectOutputStream);
        }
        objectOutputStream.writeBoolean((dockingWindow = this.getWindow()) != null);
        if (dockingWindow != null) {
            InternalDockingUtil.getWindowPath(dockingWindow).write(objectOutputStream);
        }
    }

    protected void read(ObjectInputStream objectInputStream, RootWindow rootWindow) throws IOException {
        this.parentLocation = objectInputStream.readBoolean() ? LocationDecoder.decode(objectInputStream, rootWindow) : null;
        this.window = objectInputStream.readBoolean() ? new WeakReference<DockingWindow>(InternalDockingUtil.getWindow(rootWindow, IntList.decode(objectInputStream))) : null;
    }
}

