% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{foreign_visitors_tbl_df}
\alias{foreign_visitors_tbl_df}
\title{Non-Resident Foreign Visitors to Colombia (Spanish speaking)}
\format{
A tibble with 466,915 observations and 6 variables:
\describe{
  \item{Año}{Year of the record (numeric)}
  \item{Mes}{Month of the record (character)}
  \item{Departamento}{Destination department in Colombia (character)}
  \item{Ciudad}{Destination city in Colombia (character)}
  \item{PaisOEEResidencia}{Country of residence of the foreign visitor (character)}
  \item{Cant Extranjeros no Residentes}{Number of non-resident foreign visitors (numeric)}
}
}
\source{
Data obtained from GOV.CO Datos Abiertos: \url{https://www.datos.gov.co/Comercio-Industria-y-Turismo/Extranjeros-No-Residentes/7wm8-w5ad/about_data}
}
\usage{
data(foreign_visitors_tbl_df)
}
\description{
This dataset, foreign_visitors_tbl_df, is a tibble containing information about
non-resident foreigners entering Colombia through various migration points.
It includes data on the year, month, destination department, destination city,
country of residence of the foreign visitor, and the number of non-resident foreigners.
The dataset was obtained from GOV.CO Datos Abiertos, last update on September 25, 2025.
}
\details{
The dataset name has been kept as 'foreign_visitors_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ColombiAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not
been modified in any way.
}
