% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subsets.R
\name{DemographicSubsetOperator}
\alias{DemographicSubsetOperator}
\title{Demographic Subset Operator}
\value{
char vector
Get auto generated name
}
\description{
Operators for subsetting a cohort by demographic criteria
}
\section{Super class}{
\code{\link[CohortGenerator:SubsetOperator]{CohortGenerator::SubsetOperator}} -> \code{DemographicSubsetOperator}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ageMin}}{Int between 0 and 99999 - minimum age}

\item{\code{ageMax}}{Int between 0 and 99999 - maximum age}

\item{\code{gender}}{vector of gender concept IDs}

\item{\code{race}}{character string denoting race}

\item{\code{ethnicity}}{character string denoting ethnicity}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DemographicSubsetOperator-toList}{\code{DemographicSubsetOperator$toList()}}
\item \href{#method-DemographicSubsetOperator-mapGenderConceptsToNames}{\code{DemographicSubsetOperator$mapGenderConceptsToNames()}}
\item \href{#method-DemographicSubsetOperator-getAutoGeneratedName}{\code{DemographicSubsetOperator$getAutoGeneratedName()}}
\item \href{#method-DemographicSubsetOperator-toJSON}{\code{DemographicSubsetOperator$toJSON()}}
\item \href{#method-DemographicSubsetOperator-isEqualTo}{\code{DemographicSubsetOperator$isEqualTo()}}
\item \href{#method-DemographicSubsetOperator-getGender}{\code{DemographicSubsetOperator$getGender()}}
\item \href{#method-DemographicSubsetOperator-getRace}{\code{DemographicSubsetOperator$getRace()}}
\item \href{#method-DemographicSubsetOperator-getEthnicity}{\code{DemographicSubsetOperator$getEthnicity()}}
\item \href{#method-DemographicSubsetOperator-clone}{\code{DemographicSubsetOperator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="classname"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-classname'><code>CohortGenerator::SubsetOperator$classname()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="getQueryBuilder"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-getQueryBuilder'><code>CohortGenerator::SubsetOperator$getQueryBuilder()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="initialize"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-initialize'><code>CohortGenerator::SubsetOperator$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CohortGenerator" data-topic="SubsetOperator" data-id="publicFields"><a href='../../CohortGenerator/html/SubsetOperator.html#method-SubsetOperator-publicFields'><code>CohortGenerator::SubsetOperator$publicFields()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-toList"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-toList}{}}}
\subsection{Method \code{toList()}}{
List representation of object
Map gender concepts to names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$toList()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-mapGenderConceptsToNames"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-mapGenderConceptsToNames}{}}}
\subsection{Method \code{mapGenderConceptsToNames()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$mapGenderConceptsToNames(
  mapping = list(`8507` = "males", `8532` = "females", `0` = "unknown gender")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mapping}}{optional list of mappings for concept id to nouns}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-getAutoGeneratedName"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-getAutoGeneratedName}{}}}
\subsection{Method \code{getAutoGeneratedName()}}{
name generated from subset operation properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$getAutoGeneratedName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-toJSON"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-toJSON}{}}}
\subsection{Method \code{toJSON()}}{
json serialized representation of object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$toJSON()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-isEqualTo"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-isEqualTo}{}}}
\subsection{Method \code{isEqualTo()}}{
Compare Subset to another
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$isEqualTo(criteria)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{criteria}}{DemographicSubsetOperator instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-getGender"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-getGender}{}}}
\subsection{Method \code{getGender()}}{
Gender getter - used when constructing SQL to default
NULL to an empty string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$getGender()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-getRace"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-getRace}{}}}
\subsection{Method \code{getRace()}}{
Race getter - used when constructing SQL to default
NULL to an empty string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$getRace()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-getEthnicity"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-getEthnicity}{}}}
\subsection{Method \code{getEthnicity()}}{
Ethnicity getter - used when constructing SQL to default
NULL to an empty string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$getEthnicity()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DemographicSubsetOperator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DemographicSubsetOperator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DemographicSubsetOperator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
