% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCharacteristics.R
\name{summariseCharacteristics}
\alias{summariseCharacteristics}
\title{Summarise characteristics of cohorts in a cohort table}
\usage{
summariseCharacteristics(
  cohort,
  cohortId = NULL,
  strata = list(),
  counts = TRUE,
  demographics = TRUE,
  ageGroup = NULL,
  tableIntersectFlag = list(),
  tableIntersectCount = list(),
  tableIntersectDate = list(),
  tableIntersectDays = list(),
  cohortIntersectFlag = list(),
  cohortIntersectCount = list(),
  cohortIntersectDate = list(),
  cohortIntersectDays = list(),
  conceptIntersectFlag = list(),
  conceptIntersectCount = list(),
  conceptIntersectDate = list(),
  conceptIntersectDays = list(),
  otherVariables = character(),
  estimates = list(),
  weights = NULL,
  otherVariablesEstimates = lifecycle::deprecated()
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}

\item{counts}{TRUE or FALSE. If TRUE, record and person counts will
be produced.}

\item{demographics}{TRUE or FALSE. If TRUE, patient demographics (cohort
start date, cohort end date, age, sex, prior observation, and future
observation will be summarised).}

\item{ageGroup}{A list of age groups to stratify results by.}

\item{tableIntersectFlag}{A list of arguments that uses
PatientProfiles::addTableIntersectFlag() to add variables to summarise.}

\item{tableIntersectCount}{A list of arguments that uses
PatientProfiles::addTableIntersectCount() to add variables to summarise.}

\item{tableIntersectDate}{A list of arguments that uses
PatientProfiles::addTableIntersectDate() to add variables to summarise.}

\item{tableIntersectDays}{A list of arguments that uses
PatientProfiles::addTableIntersectDays() to add variables to summarise.}

\item{cohortIntersectFlag}{A list of arguments that uses
PatientProfiles::addCohortIntersectFlag() to add variables to summarise.}

\item{cohortIntersectCount}{A list of arguments that uses
PatientProfiles::addCohortIntersectCount() to add variables to summarise.}

\item{cohortIntersectDate}{A list of arguments that uses
PatientProfiles::addCohortIntersectDate() to add variables to summarise.}

\item{cohortIntersectDays}{A list of arguments that uses
PatientProfiles::addCohortIntersectDays() to add variables to summarise.}

\item{conceptIntersectFlag}{A list of arguments that uses
PatientProfiles::addConceptIntersectFlag() to add variables to summarise.}

\item{conceptIntersectCount}{A list of arguments that uses
PatientProfiles::addConceptIntersectCount() to add variables to summarise.}

\item{conceptIntersectDate}{A list of arguments that uses
PatientProfiles::addConceptIntersectDate() to add variables to summarise.}

\item{conceptIntersectDays}{A list of arguments that uses
PatientProfiles::addConceptIntersectDays() to add variables to summarise.}

\item{otherVariables}{Other variables contained in cohort that you want to be
summarised.}

\item{estimates}{To modify the default estimates for a variable.
By default: 'min', 'q25', 'median', 'q75', 'max' for "date", "numeric" and
"integer" variables ("numeric" and "integer" also use 'mean' and 'sd'
estimates). 'count' and 'percentage' for "categorical" and "binary".
You have to provide them as a list: \code{list(age = c("median", "density"))}. You
can also use 'date', 'numeric', 'integer', 'binary', 'categorical',
'demographics', 'intersect', 'other', 'table_intersect_count', ...}

\item{weights}{Column in cohort that points to weights of each individual.}

\item{otherVariablesEstimates}{deprecated.}
}
\value{
A summary of the characteristics of the cohorts in the cohort table.
}
\description{
Summarise characteristics of cohorts in a cohort table
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)
library(CohortCharacteristics)
library(PatientProfiles)

cdm <- mockCohortCharacteristics()

cdm$cohort1 |>
  addSex() |>
  addAge(
    ageGroup = list(c(0, 40), c(41, 150))
  ) |>
  summariseCharacteristics(
    strata = list("sex", "age_group"),
    cohortIntersectFlag = list(
      "Cohort 2 Flag" = list(
        targetCohortTable = "cohort2", window = c(-365, 0)
      )
    ),
    cohortIntersectCount = list(
      "Cohort 2 Count" = list(
        targetCohortTable = "cohort2", window = c(-365, 0)
      )
    )
  ) |>
  glimpse()

mockDisconnect(cdm)
}
}
