% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paretoII.R
\name{ParetoII}
\alias{ParetoII}
\alias{dparetoII}
\alias{pparetoII}
\alias{qparetoII}
\alias{rparetoII}
\alias{mparetoII}
\title{Pareto type II distribution}
\usage{
dparetoII(x, scale, shape, log = FALSE)

pparetoII(q, scale, shape, lower.tail = TRUE, log.p = FALSE)

qparetoII(p, scale, shape, lower.tail = TRUE, log.p = FALSE)

rparetoII(n, scale, shape)

mparetoII(r, scale, shape)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{scale, shape}{scale and shape parameters; the shape argument cannot be a vector (must have length one).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{r}{raw moment order}
}
\description{
Provides density, distribution function, quantile function, random value generation
and raw moments of order \emph{r} for the Pareto type II distribution.
}
\examples{

## plot the density

ggplot(data.frame(x = c(0, 20)),
       aes(x)) +
  stat_function(fun = dparetoII,
                args = list(scale = 1,
                            shape = .3),
                colour = 'royalblue4') +
  labs(x = '',
       y = 'Density') +
  theme_classic()

}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
