% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AR1.R
\name{AR1}
\alias{AR1}
\title{Autoregressive model of first order}
\usage{
AR1(n, alpha, mean = 0, sd = 1)
}
\arguments{
\item{n}{number of values}

\item{alpha}{lag-1 autocorrelation}

\item{mean}{mean}

\item{sd}{standard deviation}
}
\description{
Generates time series from an AR1 model
}
\examples{

library(CoSMoS); library(ggplot2)

## generate 500 values from an AR1 having lag-1 autocorrelation 0.8,
## mean value equal to 0, and standard deviation equal to 1.
n <- 500

## generate white noise for comparsion
x <- rnorm(n)
ggplot() +
 geom_line(aes(x = 1:n,
               y = x)) +
   labs(x = '',
        y = 'value') +
   theme_classic()

## generete values using AR1
y <- AR1(n, .8)
ggplot() +
  geom_line(aes(x = 1:n,
                y = y)) +
  labs(x = '',
       y = 'value') +
  theme_classic()

}
