% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_k_n_partitions}
\alias{plot_k_n_partitions}
\title{Relationship Between the Number of Clusters and the Number of Unique Partitions}
\usage{
plot_k_n_partitions(partition_obj_list, object_names = NULL)
}
\arguments{
\item{partition_obj_list}{An object or a concatenation of objects returned by the
`merge_resolutions` method.}

\item{object_names}{Custom names that the user could assing to each
configuration; if not specified, the plot will use the generated configuration
names.}
}
\value{
A ggplot2 object. The color gradient suggests the frequency of the most
common partition relative to the total number of appearances of that specific
number of clusters.
}
\description{
For each configuration provided in partition_obj_list, display how
many different partitions with the same number of clusters can be obtained
by changing the seed.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(runif(500*10), nrow = 500)

# get the PCA embedding of the data
pca_embedding = irlba::irlba(expr_matrix, nv = 2)
pca_embedding = pca_embedding$u \%*\% diag(pca_embedding$d)
rownames(pca_embedding) = as.character(1:500)

# run the function on the pca embedding
resolution_result = get_resolution_importance(embedding = pca_embedding,
   resolution = c(0.8, 1),
   n_neigh = c(5, 7),
   n_repetitions = 5,
   clustering_method = 1,
   graph_type = 2,
   object_name = "name_example")

plot_k_n_partitions(resolution_result)
}
