% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clus_vus.R
\name{clus_vus}
\alias{clus_vus}
\title{Estimation of the covariate-specific VUS for clustered data.}
\usage{
clus_vus(out_clus_lme, newdata, ap_var = TRUE, subdivisions = 1000, ...)
}
\arguments{
\item{out_clus_lme}{an object of class "clus_lme", a result of \code{\link{clus_lme}} call.}

\item{newdata}{a data frame (containing specific value(s) of covariate(s)) in which to look for variables with which to estimate covariate-specific VUS. In absence of covariate, no values have to be specified.}

\item{ap_var}{logical value. If set to \code{TRUE} (default), the standard error for (estimated) covariate-specific VUS are estimated.}

\item{subdivisions}{the maximum number of subintervals used to approximate integral. Default is 1000.}

\item{...}{additional arguments to be passed to \code{\link[stats]{integrate}}.}
}
\value{
\code{clus_vus} returns an object of class "VUS" which is a list containing at least the following components:

\item{call}{the matched call.}
\item{vus_est}{a vector containing the estimated covariate-specific VUS.}
\item{vus_se}{a vector containing the standard errors.}
\item{mess_order}{a diagnostic message from checking the monontone ordering.}
\item{newdata}{value(s) of covariate(s).}
\item{n_p}{total number of regressors in the model.}

Generic functions such as \code{print} is also used to show the results.
}
\description{
This function estimates the covariate-specific VUS of a continuous diagnostic test in the setting of clustered data as described in Xiong et al. (2018). This function allows to estimate covariate-specific VUS at multiple points for covariates.
}
\details{
This function implements a method in Xiong et al. (2018) for estimating covariate-specific VUS of a continuous diagnostic test in a clustered design with three ordinal groups. The estimator is based on results from \code{\link{clus_lme}}, which uses the REML approach. The standard error of the estimated covariate-specific VUS is approximated through the Delta method.

Before performing estimation, a check for the monotone ordering assumption is performed. This means that, for the fixed values of covariates, three predicted mean values for test results in three diagnostic groups are compared. If the assumption is not meet, the covariate-specific VUS at the values of covariates are not estimated. In addition, this function also performs the statistical test, \eqn{H_0: VUS = 1/6} versus an alternative of interest.
}
\examples{
data(data_3class)
## One covariate
out1 <- clus_lme(fixed_formula = Y ~ X1, name_class = "D",
                 name_clust = "id_Clus", data = data_3class)

### Estimate covariate-specific VUS at one value of one covariate
out_vus1 <- clus_vus(out1, newdata = data.frame(X1 = 0.5))
ci_clus_vus(out_vus1, ci_level = 0.95)

### Estimate covariate-specific VUS at multiple values of one covariate
out_vus2 <- clus_vus(out1, newdata = data.frame(X1 = c(-0.5, 0, 0.5)))
ci_clus_vus(out_vus2, ci_level = 0.95)

## Two covariates
out2 <- clus_lme(fixed_formula = Y ~ X1 + X2, name_class = "D",
                 name_clust = "id_Clus", data = data_3class)

### Estimate covariate-specific VUS at one point
out_vus3 <- clus_vus(out2, newdata = data.frame(X1 = 1.5, X2 = 1))
ci_clus_vus(out_vus3, ci_level = 0.95)

### Estimate covariate-specific VUS at three points
out_vus4 <- clus_vus(out2, newdata = data.frame(X1 = c(-0.5, 0.5, 0.5),
                                                X2 = c(0, 0, 1)))
ci_clus_vus(out_vus4, ci_level = 0.95)

}
\references{
Xiong, C., Luo, J., Chen L., Gao, F., Liu, J., Wang, G., Bateman, R. and Morris, J. C. (2018)
``Estimating diagnostic accuracy for clustered ordinal diagnostic groups in the three-class case -- Application to the early diagnosis of Alzheimer disease''.
\emph{Statistical Methods in Medical Research}, \bold{27}, 3, 701-714.
}
