% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{fpc.clusterboot}
\alias{fpc.clusterboot}
\title{Resampling according to the methods discussed in Hennig (2007)}
\usage{
fpc.clusterboot(
  data,
  B,
  distances = (inherits(data, "dist")),
  bootmethod = "boot",
  bscompare = TRUE,
  multipleboot = FALSE,
  jittertuning = 0.05,
  noisetuning = c(0.05, 4),
  subtuning = floor(nrow(data)/2),
  clustermethod,
  noisemethod = FALSE,
  count = TRUE,
  seed = NULL,
  datatomatrix = TRUE,
  ...
)
}
\arguments{
\item{data}{a data matrix or distance object which will be the input to the clustering function}

\item{B}{number of bootstrap replicates}

\item{distances}{see \code{?fpc::clusterboot}}

\item{bootmethod}{see \code{?fpc::clusterboot}}

\item{bscompare}{see \code{?fpc::clusterboot}}

\item{multipleboot}{see \code{?fpc::clusterboot}}

\item{jittertuning}{see \code{?fpc::clusterboot}}

\item{noisetuning}{see \code{?fpc::clusterboot}}

\item{subtuning}{see \code{?fpc::clusterboot}}

\item{clustermethod}{see \code{?fpc::clusterboot}}

\item{noisemethod}{see \code{?fpc::clusterboot}}

\item{count}{see \code{?fpc::clusterboot}}

\item{seed}{see \code{?fpc::clusterboot}}

\item{datatomatrix}{see \code{?fpc::clusterboot}}

\item{...}{additional arguments to be sent to the function specified in clustermethod}
}
\value{
a list with two components; boot.out contains the computations for clusboot and out contains the clustering
solution of the original data set
}
\description{
Resampling according to the methods discussed in Hennig (2007)
}
