% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetable.R
\name{spacetable}
\alias{spacetable}
\title{Add space to the results of a statistic table}
\usage{
spacetable(tab, at.row = 6)
}
\arguments{
\item{tab}{a data.frame. Normally, the output part of a desc object}

\item{at.row}{Numeric (between 1 and \code{ncol(tab)}) or Character (a column name of tab)}
}
\value{
A data.frame with some space between levels of the variable specified by \code{at.row}
}
\description{
\code{spacetable} 
Add space at some interval in a table of statistics
}
\details{
Used internally into \code{report.lsmeans}, \code{report.quanti} and \code{report.quali}
}
\examples{

data(datafake)
spacetable(report.quali(data=datafake,y="y_logistic",x1="GROUP",
x2="TIMEPOINT")$output,at.row="TIMEPOINT")


}
\seealso{
\code{\link{report.quanti}}  \code{\link{report.quali}}  \code{\link{report.lsmeans}}
}
