% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_desc_quali.R
\name{gg_desc_quali}
\alias{gg_desc_quali}
\title{Creates a ggplot object corresponding to a qualitative desc object}
\usage{
gg_desc_quali(desc, title = "", ylim = NULL, xlim = NULL,
  xlab = "", ylab = "Percentage", legend.label = "Group")
}
\arguments{
\item{desc}{Desc object}

\item{title}{Character The title of the plot}

\item{ylim}{Numeric of length 2 for setting y axis limits}

\item{xlim}{Numeric of length 2 for setting x axis limits}

\item{xlab}{Character Label for x-axis}

\item{ylab}{Character Label for y-axis}

\item{legend.label}{Character Label for the legend (used only if x1 and x2 are not NULL in the desc object)}
}
\description{
\code{gg_desc_quali} 
ggplot object is printed. It is used internally in function \code{\link{plot.desc}}.
It's easier to use this last one.
}
\details{
No detail
}
\examples{
 \dontshow{
data(datafake)

desc=report.quali(data=datafake,y="y_logistic",x1="GROUP",
	x2="TIMEPOINT")

gg=ClinReport:::gg_desc_quali(desc,
title="Qualitative desc object with 2 explicative variables",
legend.label="Y levels")


desc2=report.quali(data=datafake,y="y_logistic",x1="GROUP")
ClinReport:::gg_desc_quali(desc2,title="Qualitative desc object with 1 explicative variable")

desc3=report.quali(data=datafake,y="y_logistic")
ClinReport:::gg_desc_quali(desc3,title="Qualitative desc object with 1 explicative variable")






}

}
\seealso{
\code{\link{report.quali}} \code{\link{plot.desc}} \code{\link{gg_desc_quanti}}  \code{\link{gg_desc_quali}}   \code{\link{gg_desc_lsmeans}}
}
