% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCCAQ.R
\name{bccaq.netcdf.wrapper}
\alias{bccaq.netcdf.wrapper}
\title{Wrapper function for the entire BCCAQ downscaling method}
\usage{
bccaq.netcdf.wrapper(gcm.file, obs.file, out.file, varname = "tasmax")
}
\arguments{
\item{gcm.file}{Filename of GCM simulations in NetCDF format}

\item{obs.file}{Filename of high-res gridded historical observations}

\item{out.file}{The file to create (or overwrite) with the final BCCAQ NetCDF output}

\item{varname}{Name of the NetCDF variable to downscale (e.g. 'tasmax')}
}
\description{
BCCAQ is a hybrid downscaling method that combines
outputs from Climate Analogues (CA) and quantile mapping at the
fine-scale resolution.  First, the CA and climate imprint (CI)
plus quantile delta mapping (QDM) algorithms are run
independently. BCCAQ then combines outputs from the two by
taking the daily QDM outputs at each fine-scale grid point and
reordering them within a given month according to the daily
CA ranks, i.e., using a form of Empirical Copula
Coupling.

The combination mitigates some potential issues with
the separate algorithms. First, because the optimal weights
used to combine the analogues in BCCA are derived on a
day-by-day basis, without reference to the full historical data
set, the algorithm may fail to reproduce long-term trends from
the climate model. Second, the CI/QDM bias correction step
fixes precipitation "drizzle" and other residual biases caused
by the linear combination of daily fields from CA. Third,
reordering data for each fine-scale grid point within a month
effectively breaks the overly smooth representation of sub
grid-scale spatial variability inherited from CI/QDM, thereby
resulting in a more accurate representation of event-scale
spatial gradients; this also prevents the downscaled outputs
from drifting too far from the climate model's long-term trend.
}
\references{
Werner, A. T., & Cannon, A. J. (2016). Hydrologic extremes  - an intercomparison of multiple gridded statistical downscaling methods. Hydrology and Earth System Sciences, 20(4), 1483-1508. doi: 10.5194/hess-20-1483-2016
}

