% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schedrule.R
\name{schedrule}
\alias{schedrule}
\title{Schedules of awards of a rule}
\usage{
schedrule(d, claimants, Rule, col = NULL, points = 201, legend = TRUE)
}
\arguments{
\item{d}{A vector of claims.}

\item{claimants}{A subset of claimants.}

\item{Rule}{The rule: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, or Talmud.}

\item{col}{The colors. If col = NULL then the sequence of default colors is chosen randomly.}

\item{points}{The number of values of the endowment to draw the path.}

\item{legend}{A logical value. The color legend is shown if legend = TRUE.}
}
\value{
The graphical representation of the schedules of awards of a rule for a claims vector and a group of claimants.
}
\description{
This function returns the graphical representation of the schedules of awards of a rule for a claims vector.
}
\details{
Let \eqn{d\in \mathcal{R}^n}{d}, with \eqn{d\ge 0}, be a vector of claims and
 denote  \eqn{D=\sum_{i=1}^{n} d_i}{D=\sum di} the sum of claims.

The schedules of awards of a rule \eqn{R} for claimant \eqn{i} is the function \eqn{S} that assigns to each \eqn{E\in [0,D]}{0\le E \le D} the  value:
\eqn{S(E)=R_i(E,d)\in \mathcal{R}}{S(E)=Ri(E,d)}.
Therefore, the schedules of awards of a rule plots each claimants's award as a function of \eqn{E}.
}
\examples{
d=c(2,4,7,8)
Rule=Talmud
claimants=c(1,2,3,4)
col=c("red","green","yellow","blue")
schedrule(d,claimants,Rule,col)
# The schedules of awards of the concede-and-divide rule.
schedrule(c(2,4),c(1,2),CD)
}
\references{
Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{schedrules}, \link{pathawards}, \link{pathawards3}, \link{verticalruleplot}
}
