% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AncStateEstMatrix.R
\name{AncStateEstMatrix}
\alias{AncStateEstMatrix}
\title{Ancestral Character State Estimation}
\usage{
AncStateEstMatrix(CladisticMatrix, Tree, EstimateAllNodes = FALSE,
  EstimateTipValues = FALSE, InapplicablesAsMissing = FALSE,
  PolymorphismBehaviour = "equalp", UncertaintyBehaviour = "equalp",
  Threshold = 0.01)
}
\arguments{
\item{CladisticMatrix}{A character-taxon matrix in the format imported by \link{ReadMorphNexus}.}

\item{Tree}{A tree (phylo object) with branch lengths that represents the relationships of the taxa in \code{CladisticMatrix}.}

\item{EstimateAllNodes}{Logical that allows the user to make estimates for all ancestral values. The default (\code{FALSE}) will only make estimates for nodes that link coded terminals (recommended).}

\item{EstimateTipValues}{Logical that allows the user to make estimates for tip values. The default (\code{FALSE}) will only makes estimates for internal nodes (recommended).}

\item{InapplicablesAsMissing}{Logical that decides whether or not to treat inapplicables as missing (TRUE) or not (FALSE, the default and recommended option).}

\item{PolymorphismBehaviour}{One of either "equalp" or "treatasmissing".}

\item{UncertaintyBehaviour}{One of either "equalp" or "treatasmissing".}

\item{Threshold}{The threshold value to use when collapsing marginal likelihoods to discrete state(s).}
}
\value{
\item{anc.lik.matrix}{A matrix of nodes (hypothetical ancestors; rows) against characters (columns) listing the reconstructed ancestral states.}
}
\description{
Given a tree and a cladistic matrix uses likelihood to estimate the ancestral states for every character.
}
\details{
Uses either the \link{rerootingMethod} (Yang et al. 1995) as implemented in the \link{phytools} package (discrete characters) or the \link{ace} function in the \link{ape} package (continuous characters) to make ancestral state estimates. For discrete characters these are collapsed to the most likely state (or states, given equal likelihoods or likelihood within a defined threshold value). In the latter case the resulting states are represented as an uncertainty (i.e., states separated by a slash, e.g., 0/1. This is the method used by Brusatte et al. (2014).
}
\examples{

# Set random seed:
set.seed(4)

# Generate a random tree for the Day data set:
tree <- rtree(n = nrow(Day2016$Matrix_1$Matrix))

# Update taxon names to match those in the data matrix:
tree$tip.label <- rownames(Day2016$Matrix_1$Matrix)

# Set root time by making youngest taxon extant:
tree$root.time <- max(diag(vcv(tree)))

# Use Day matrix as cladistic matrix:
CladisticMatrix <- Day2016

# Prune most characters out to make example run fast:
CladisticMatrix <- MatrixPruner(CladisticMatrix,
  characters2prune = c(2:3, 5:37))

# Estimate ancestral states:
AncStateEstMatrix(CladisticMatrix = CladisticMatrix,
  Tree = tree)

}
\references{
Brusatte, S. L., Lloyd, G. T., Wang, S. C. and Norell, M. A., 2014. Gradual assembly of avian body plan culminated in rapid rates of evolution across dinosaur-bird transition. Current Biology, 24, 2386-2392.

Yang, Z., Kumar, S. and Nei, M., 1995. A new method of inference of ancestral nucleotide and amino acid sequences. Genetics, 141, 1641-1650.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com} and Thomas Guillerme \email{guillert@tcd.ie}
}
