% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteMorphNexus.R
\name{WriteMorphNexus}
\alias{WriteMorphNexus}
\title{Writes out a morphological #NEXUS data file}
\usage{
WriteMorphNexus(CladisticMatrix, filename)
}
\arguments{
\item{CladisticMatrix}{The cladistic matrix in the format imported by \link{ReadMorphNexus}.}

\item{filename}{The file name to write to. Should end in \code{.nex}.}
}
\description{
Writes out a morphological data file in #NEXUS format.
}
\details{
Writes out a #NEXUS (Maddison et al. 1997) data file representing the distribution of characters in a set of taxa. Data must be in the format created by importing data with \link{ReadMorphNexus}.
}
\examples{

# Write out Michaux 1989 to current working directory:
WriteMorphNexus(CladisticMatrix = Michaux1989, filename = "Michaux1989.nex")

# Remove file when finished:
file.remove("Michaux1989.nex")

}
\references{
Maddison, D. R., Swofford, D. L. and Maddison, W. P., 1997. NEXUS: an extensible file format for systematic information. Systematic Biology, 46, 590-621.
}
\seealso{
\link{WriteMorphTNT}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
\keyword{NEXUS}
