% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{rInvCholWishart}
\alias{rInvCholWishart}
\title{Cholesky Factor of Random Inverse Wishart Distributed Matrices}
\usage{
rInvCholWishart(n, df, Sigma)
}
\arguments{
\item{n}{integer sample size.}

\item{df}{numeric parameter, "degrees of freedom".}

\item{Sigma}{positive definite \eqn{(p * p)} "scale" matrix, the matrix parameter of the distribution.}
}
\value{
a numeric array, say R, of dimension \eqn{p * p * n}, where each \code{R[,,i]} is a Cholesky decomposition of a realization of the Wishart distribution \eqn{W_p(Sigma, df)}. Based on a modification of the existing code for the \code{rWishart} function
}
\description{
Generate n random matrices, distributed according
   to the Cholesky factor of an inverse Wishart distribution with
   parameters \code{Sigma} and \code{df}, \eqn{W_p(Sigma, df)}.
   Note there are different ways of parameterizing the Inverse
   Wishart distribution, so check which one you need.
}
\examples{
# How it is parameterized:
set.seed(20180211)
A <- rCholWishart(1,10,3*diag(5))[,,1]
A
set.seed(20180211)
B <- rInvCholWishart(1,10,1/3*diag(5))[,,1]
B
crossprod(A) \%*\% crossprod(B)

set.seed(20180211)
C <- chol(stats::rWishart(1,10,3*diag(5))[,,1])
C
}
\seealso{
\code{\link{rWishart}} and \code{\link{rCholWishart}}
}
