/*
 * Decompiled with CFR 0.152.
 */
package core.lattice;

import core.lattice.Lattice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.TreeSet;

public class LatticeNode
implements Comparable<LatticeNode> {
    TreeSet<LatticeNode> children;
    int[] variablesNumbers;
    BitSet[] records;
    int[] dimensionsForVariables;
    int nbVariables;
    int nbCells;
    boolean entropyComputed = false;
    Lattice lattice;

    public int[] getVariablesNumbers() {
        return this.variablesNumbers;
    }

    public LatticeNode(Lattice lattice, int[] variablesNumbers, int[] dimensionsForVariables, BitSet[] records, LatticeNode ... parents) {
        this.lattice = lattice;
        this.nbVariables = this.lattice.getNbVariables();
        this.variablesNumbers = variablesNumbers;
        this.dimensionsForVariables = dimensionsForVariables;
        this.children = new TreeSet();
        this.nbCells = 1;
        int i = 0;
        while (i < variablesNumbers.length) {
            this.nbCells *= dimensionsForVariables[variablesNumbers[i]];
            ++i;
        }
        this.records = records;
        LatticeNode[] latticeNodeArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            LatticeNode parent = latticeNodeArray[n2];
            parent.addChild(this);
            ++n2;
        }
    }

    public LatticeNode(Lattice lattice, int[] dimensionsForVariables) {
        this.lattice = lattice;
        this.variablesNumbers = null;
        this.dimensionsForVariables = dimensionsForVariables;
        this.children = new TreeSet();
        this.records = null;
    }

    protected void computeRecords() {
        if (this.records == null) {
            this.records = new BitSet[this.nbCells];
            if (this.getLevel() == 1) {
                System.out.println(this.getLevel());
            }
            int i = 0;
            while (i < this.nbCells) {
                int[] indexes = this.getIndexes(i);
                BitSet set = (BitSet)this.lattice.getSetForVariable(this.variablesNumbers[0], indexes[0]).clone();
                set.and(this.lattice.getSetForVariable(this.variablesNumbers[1], indexes[1]));
                this.records[i] = set;
                ++i;
            }
        }
    }

    public int[] getMatrix() {
        int[] matrix = new int[this.nbCells];
        if (this.getLevel() <= 1) {
            this.computeRecords();
            int i = 0;
            while (i < matrix.length) {
                matrix[i] = this.records[i].cardinality();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nbCells) {
                int[] indexes = this.getIndexes(i);
                BitSet set = (BitSet)this.lattice.getSetForVariable(this.variablesNumbers[0], indexes[0]).clone();
                int j = 1;
                while (j < this.variablesNumbers.length) {
                    set.and(this.lattice.getSetForVariable(this.variablesNumbers[j], indexes[j]));
                    ++j;
                }
                matrix[i] = set.cardinality();
                ++i;
            }
        }
        return matrix;
    }

    public int getMatrixCell(int i) {
        if (this.getLevel() <= 1) {
            this.computeRecords();
            return this.records[i].cardinality();
        }
        int[] indexes = this.getIndexes(i);
        BitSet set = (BitSet)this.lattice.getSetForVariable(this.variablesNumbers[0], indexes[0]).clone();
        int j = 1;
        while (j < this.variablesNumbers.length) {
            set.and(this.lattice.getSetForVariable(this.variablesNumbers[j], indexes[j]));
            ++j;
        }
        return set.cardinality();
    }

    public int getMatrixCell(int[] indexes) {
        if (this.getLevel() <= 1) {
            this.computeRecords();
            return this.records[this.getIndex(indexes)].cardinality();
        }
        BitSet set = (BitSet)this.lattice.getSetForVariable(this.variablesNumbers[0], indexes[0]).clone();
        int j = 1;
        while (j < this.variablesNumbers.length) {
            set.and(this.lattice.getSetForVariable(this.variablesNumbers[j], indexes[j]));
            ++j;
        }
        return set.cardinality();
    }

    public LatticeNode getChild(int variableNumber, Lattice lattice) {
        int[] childVariablesNumbers = new int[this.variablesNumbers.length + 1];
        int currentIndex = 0;
        while (currentIndex < this.variablesNumbers.length && this.variablesNumbers[currentIndex] < variableNumber) {
            childVariablesNumbers[currentIndex] = this.variablesNumbers[currentIndex];
            ++currentIndex;
        }
        childVariablesNumbers[currentIndex] = variableNumber;
        ++currentIndex;
        while (currentIndex < childVariablesNumbers.length) {
            childVariablesNumbers[currentIndex] = this.variablesNumbers[currentIndex - 1];
            ++currentIndex;
        }
        LatticeNode foundNode = null;
        for (LatticeNode child : this.children) {
            int i = 0;
            while (i < childVariablesNumbers.length) {
                if (childVariablesNumbers[i] < child.variablesNumbers[i] || childVariablesNumbers[i] > child.variablesNumbers[i]) break;
                ++i;
            }
            if (i != childVariablesNumbers.length) continue;
            foundNode = child;
            break;
        }
        if (foundNode == null) {
            ArrayList<LatticeNode> childParents = new ArrayList<LatticeNode>();
            int i = 0;
            while (i < childVariablesNumbers.length) {
                int[] parentVariableNumbers = new int[childVariablesNumbers.length - 1];
                int j = 0;
                while (j < childVariablesNumbers.length) {
                    if (j < i) {
                        parentVariableNumbers[j] = childVariablesNumbers[j];
                    } else if (j > i) {
                        parentVariableNumbers[j - 1] = childVariablesNumbers[j];
                    }
                    ++j;
                }
                childParents.add(lattice.getNode(parentVariableNumbers));
                ++i;
            }
            foundNode = new LatticeNode(lattice, childVariablesNumbers, this.dimensionsForVariables, null, childParents.toArray(new LatticeNode[0]));
        }
        return foundNode;
    }

    @Override
    public int compareTo(LatticeNode o) {
        if (o.variablesNumbers == null) {
            return -1;
        }
        if (this.variablesNumbers.length < o.variablesNumbers.length) {
            return -1;
        }
        if (this.variablesNumbers.length > o.variablesNumbers.length) {
            return 1;
        }
        int i = 0;
        while (i < this.variablesNumbers.length) {
            if (this.variablesNumbers[i] < o.variablesNumbers[i]) {
                return -1;
            }
            if (this.variablesNumbers[i] > o.variablesNumbers[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    protected BitSet getSet(int ... indexes) {
        if (this.records == null) {
            this.computeRecords();
        }
        return this.records[this.getIndex(indexes)];
    }

    public int getNbCells() {
        return this.nbCells;
    }

    protected final int getIndex(int ... indexes) {
        int index = indexes[0];
        int i = 1;
        while (i < this.variablesNumbers.length) {
            index *= this.dimensionsForVariables[this.variablesNumbers[i]];
            index += indexes[i];
            ++i;
        }
        return index;
    }

    public final int getIndexTooBig(int[] indexes) {
        int index = indexes[0];
        int i = 1;
        while (i < this.variablesNumbers.length) {
            index *= this.dimensionsForVariables[this.variablesNumbers[i]];
            index += indexes[i];
            ++i;
        }
        return index;
    }

    public final int[] getIndexes(int index) {
        int[] indexes = new int[this.variablesNumbers.length];
        int i = indexes.length - 1;
        while (i > 0) {
            int dim = this.dimensionsForVariables[this.variablesNumbers[i]];
            indexes[i] = index % dim;
            index /= dim;
            --i;
        }
        indexes[0] = index;
        return indexes;
    }

    public String toString() {
        return "lattice node:" + Arrays.toString(this.variablesNumbers);
    }

    protected void addChild(LatticeNode child) {
        this.children.add(child);
    }

    public int getLevel() {
        if (this.variablesNumbers == null) {
            return 0;
        }
        return this.variablesNumbers.length;
    }
}

