% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{perd_get}
\alias{perd_get}
\title{Compute the Periodogram of Multivariate Time Series}
\usage{
perd_get(Y)
}
\arguments{
\item{Y}{A numeric matrix of dimension \code{T x N}, where each column is a univariate time series.}
}
\value{
A numeric matrix of dimension \code{N x L}, where each row is the periodogram of a time series.
}
\description{
This function computes the periodogram for each time series in the input matrix.
}
\examples{
set.seed(123)
Y <- matrix(rnorm(20), ncol = 4)
perd <- perd_get(Y)

}
