% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_model.R
\name{query_model}
\alias{query_model}
\title{Generate estimands data frame}
\usage{
query_model(
  model,
  queries = NULL,
  given = NULL,
  using = list("parameters"),
  parameters = NULL,
  stats = NULL,
  n_draws = 4000,
  expand_grid = FALSE,
  case_level = FALSE,
  query = NULL,
  cred = 95
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{queries}{A vector of strings or list of strings specifying queries
on potential outcomes such as "Y[X=1] - Y[X=0]".}

\item{given}{A vector or list of strings specifying givens. A given is
a quoted expression that evaluates to a logical statement. Allows estimand
to be conditioned on *observational* (or counterfactual) distribution.}

\item{using}{A vector or list of strings. Whether to use priors,
posteriors or parameters.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to
specify (optional). By default, parameters is drawn from the parameters dataframe.
See \code{inspect(model, "parameters_df")}.}

\item{stats}{Functions to be applied to estimand distribution.
If NULL, defaults to mean, standard deviation,
and 95\% confidence interval. Functions should return a single numeric
value.}

\item{n_draws}{An integer. Number of draws.}

\item{expand_grid}{Logical. If \code{TRUE} then all combinations of
provided lists are examined. If not then each list is cycled through
separately. Defaults to FALSE.}

\item{case_level}{Logical. If TRUE estimates the probability of the
query for a case.}

\item{query}{alias for queries}

\item{cred}{size of the credible interval ranging between 0 and 100}
}
\value{
A data frame with columns Model, Query, Given and Using
  defined by corresponding input values. Further columns are generated
  as specified in \code{stats}.
}
\description{
Calculated from a parameter vector, from a prior or
from a posterior distribution.
}
\details{
Queries can condition on observed or counterfactual quantities.
Nested or "complex" counterfactual queries of the form
\code{Y[X=1, M[X=0]]} are allowed.
}
\examples{
model <- make_model("X -> Y")
query_model(model, "Y[X=1] - Y[X = 0]", using = "priors")
query_model(model, "Y[X=1] > Y[X = 0]", using = "parameters")
query_model(model, "Y[X=1] > Y[X = 0]", using = c("priors", "parameters"))
\donttest{

# `expand_grid= TRUE` requests the Cartesian product of arguments

models <- list(
 M1 = make_model("X -> Y"),
 M2 = make_model("X -> Y") |>
   set_restrictions("Y[X=1] < Y[X=0]")
 )


query_model(
  models,
  query = list(ATE = "Y[X=1] - Y[X=0]",
               Share_positive = "Y[X=1] > Y[X=0]"),
  given = c(TRUE,  "Y==1 & X==1"),
  using = c("parameters", "priors"),
  expand_grid = FALSE)

query_model(
  models,
  query = list(ATE = "Y[X=1] - Y[X=0]",
               Share_positive = "Y[X=1] > Y[X=0]"),
  given = c(TRUE,  "Y==1 & X==1"),
  using = c("parameters", "priors"),
  expand_grid = TRUE)

# An example of a custom statistic: uncertainty of token causation
f <- function(x) mean(x)*(1-mean(x))

query_model(
  model,
  using = list( "parameters", "priors"),
  query = "Y[X=1] > Y[X=0]",
  stats = c(mean = mean, sd = sd, token_variance = f))
}
}
