% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_par_values.R
\name{make_par_values_multiple}
\alias{make_par_values_multiple}
\title{Make par values multiple}
\usage{
make_par_values_multiple(
  model,
  y = get_priors(model),
  x = NA,
  distribution = NA,
  node = NA,
  label = NA,
  statement = NA,
  confound = NA,
  nodal_type = NA,
  param_names = NA,
  param_set = NA,
  normalize = FALSE
)
}
\arguments{
\item{model}{A model created with \code{make_model}}

\item{y}{Vector of real non negative values to be changed}

\item{x}{Vector of real non negative values to be substituted into y}

\item{distribution}{String indicating a common prior distribution (uniform, jeffreys or certainty)}

\item{node}{A string indicating nodes for which priors are to be altered}

\item{label}{String. Label for nodal type indicating nodal types for which priors are to be altered}

\item{statement}{A causal query that determines nodal types for which priors are to be altered}

\item{confound}{A confound statement that restricts nodal types for which priors are to be altered}

\item{nodal_type}{String. Label for nodal type indicating nodal types for which priors are to be altered}

\item{param_names}{String. The name of specific parameter in the form of, for example, 'X.1', 'Y.01'}

\item{param_set}{String. Indicates the name of the set of parameters to be modified (useful when setting confounds)}

\item{normalize}{Logical. If TRUE normalizes such that param set probabilities sum to 1.}
}
\description{
Internal function to create parameter vector when list like arguments are provided
}
\seealso{
Other priors: 
\code{\link{get_priors}()},
\code{\link{make_par_values}()},
\code{\link{make_priors}()},
\code{\link{make_values_task_list}()},
\code{\link{set_priors}()}
}
\concept{priors}
\keyword{internal}
