% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipweighting.R
\name{ipweighting}
\alias{ipweighting}
\title{Parametric IP Weighting}
\usage{
ipweighting(
  data,
  f = NA,
  family = gaussian(),
  p.f = NA,
  p.simple = pkg.env$simple,
  p.family = binomial(),
  p.scores = NA,
  SW = TRUE,
  n.boot = 0,
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables in the model.
This should be the same data used in \code{\link[=init_params]{init_params}}.}

\item{f}{(optional) an object of class "formula" that overrides the default parameter}

\item{family}{the family to be used in the general linear model.
By default, this is set to \code{\link[stats:gaussian]{gaussian}}.}

\item{p.f}{(optional) an object of class "formula" that overrides the default formula for the denominator of the IP
weighting function.}

\item{p.simple}{a boolean indicator to build default formula with interactions for the propensity models.
If true, interactions will be excluded. If false, interactions will be included. By
default, simple is set to false.
NOTE: if this is changed, the coefficient for treatment may not accurately represent the average causal effect.}

\item{p.family}{the family to be used in the underlying propensity model.
By default, this is set to \code{\link[stats:binomial]{binomial}}.}

\item{p.scores}{(optional) use calculated propensity scores for the weights. If using standardized weights,
the numerator will still be modeled.}

\item{SW}{a boolean indicator to indicate the use of standardized weights. By default, this is set to true.}

\item{n.boot}{(optional) an integer value that indicates number of bootstrap iterations to calculate standard error.
If no value is given, the standard error from the underlying linear model will be used.}

\item{...}{additional arguments that may be passed to the underlying \code{\link[stats:glm]{glm}} model.}
}
\value{
\code{ipweighting} returns an object of \code{\link[base:class]{class} "ipweighting"}.

The functions \code{print}, \code{summary}, and \code{predict} can be used to interact with
the underlying \code{glm} model.

An object of class \code{"ipweighting"} is a list containing the following:

 \item{call}{the matched call.}
 \item{formula}{the formula used in the model.}
 \item{model}{the underlying glm model.}
 \item{weights}{the estimated IP weights.}
 \item{ATE}{the estimated average treatment effect (risk difference).}
 \item{ATE.summary}{a data frame containing the ATE, SE, and 95\% CI of the ATE. }
}
\description{
`ipweighting` uses the \code{\link[=propensity_scores]{propensity_scores}} function to generate inverse probability
weights. The weights can either be standardized weights or non-standardized weights. The weights are used to train a
general linear model whose coefficient for treatment represents the average treatment effect on the additive scale.
}
\examples{
library(causaldata)
data(nhefs)
nhefs.nmv <- nhefs[which(!is.na(nhefs$wt82)), ]
nhefs.nmv$qsmk <- as.factor(nhefs.nmv$qsmk)

confounders <- c(
  "sex", "race", "age", "education", "smokeintensity",
  "smokeyrs", "exercise", "active", "wt71"
)

init_params(wt82_71, qsmk,
  covariates = confounders,
  data = nhefs.nmv
)

# model using all defaults
model <- ipweighting(data = nhefs.nmv)
summary(model)

# Model using calculated propensity scores and manual outcome formula
p.scores <- propensity_scores(nhefs.nmv)$p.scores
model <- ipweighting(wt82_71 ~ qsmk, p.scores = p.scores, data = nhefs.nmv)
summary(model)

}
