% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permTestSlope.R, R/permTestSlope.default.R,
%   R/permTestSlope.formula.R
\name{permTestSlope}
\alias{permTestSlope}
\alias{permTestSlope.default}
\alias{permTestSlope.formula}
\title{Permutation test for the Slope}
\usage{
permTestSlope(x, ...)

\method{permTestSlope}{default}(
  x,
  y,
  B = 999,
  alternative = "two.sided",
  plot.hist = TRUE,
  legend.loc = "topright",
  plot.qq = FALSE,
  x.name = deparse(substitute(x)),
  y.name = deparse(substitute(y)),
  ...
)

\method{permTestSlope}{formula}(formula, data, subset, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{y}{a numeric vector.}

\item{B}{the number of resamples to draw (positive integer greater than 2).}

\item{alternative}{alternative hypothesis. Options are \code{"two.sided"},
\code{"less"} or \code{"greater"}.}

\item{plot.hist}{a logical value. If \code{TRUE}, plot the distribution of
the slopes obtained from each resample.}

\item{legend.loc}{location of the legend on the histogram. Options are
\code{"topright"}, \code{"topleft"}, \code{"bottomleft"} and
\code{"bottomright"}.}

\item{plot.qq}{a logical value. If \code{TRUE}, plot the normal
quantile-quantile plot of the slopes obtained from each resample.}

\item{x.name}{Label for variable x}

\item{y.name}{Label for variable y}

\item{formula}{a formula \code{y ~ x} where \code{x, y} are numeric vectors.}

\item{data}{a data frame that contains the variables given in the formula.}

\item{subset}{an optional expression indicating what observations to use.}
}
\value{
Returns invisibly a vector of the slopes obtained by the
randomization.
}
\description{
Hypothesis test for a slope of a simple linear regression model. 
The null hypothesis is that the population slope is 0.
}
\details{
Perform a permutation test to test \eqn{latex}{H_0: \beta = 0}, where
\eqn{latex}{\beta}is the population slope. The rows of the second
variable are permuted and the slope is re-computed.

The mean and standard error of the permutation distribution is printed as
well as a P-value.

Observations with missing values are removed.
}
\section{Methods (by class)}{
\itemize{
\item \code{permTestSlope(default)}: Permutation test for the slope

\item \code{permTestSlope(formula)}: Permutation test for the slope

}}
\examples{

plot(states03$HSGrad, states03$TeenBirths)
lm(HSGrad ~ TeenBirths, data = states03)

permTestSlope(states03$HSGrad, states03$TeenBirths)
permTestSlope(TeenBirths ~ HSGrad, data = states03)

}
\references{
Tim Hesterberg's website:
\url{https://www.timhesterberg.net/bootstrap-and-resampling}
}
\author{
Adam Loy, Laura Chihara
}
\keyword{correlation}
\keyword{permutation}
\keyword{randomization}
\keyword{resampling}
\keyword{test}
