% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduction_solvers.R, R/conic_solvers.R
\docType{class}
\name{ReductionSolver-class}
\alias{ReductionSolver-class}
\alias{mip_capable,ReductionSolver-method}
\alias{name,ReductionSolver-method}
\alias{import_solver,ReductionSolver-method}
\alias{is_installed,ReductionSolver-method}
\alias{solve_via_data,ReductionSolver-method}
\alias{reduction_solve,ReductionSolver,ANY-method}
\alias{solve_via_data,ECOS-method}
\title{The ReductionSolver class.}
\usage{
\S4method{mip_capable}{ReductionSolver}(solver)

\S4method{name}{ReductionSolver}(x)

\S4method{import_solver}{ReductionSolver}(solver)

\S4method{is_installed}{ReductionSolver}(solver)

\S4method{solve_via_data}{ReductionSolver}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache = list()
)

\S4method{reduction_solve}{ReductionSolver,ANY}(
  object,
  problem,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts
)

\S4method{solve_via_data}{ECOS}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache = list()
)
}
\arguments{
\item{solver, object, x}{A \linkS4class{ReductionSolver} object.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{An integer number indicating level of solver verbosity.}

\item{feastol}{The feasible tolerance on the primal and dual residual.}

\item{reltol}{The relative tolerance on the duality gap.}

\item{abstol}{The absolute tolerance on the duality gap.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}

\item{problem}{A \linkS4class{Problem} object.}
}
\description{
The ReductionSolver class.
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable}: Can the solver handle mixed-integer programs?

\item \code{name}: Returns the name of the solver

\item \code{import_solver}: Imports the solver

\item \code{is_installed}: Is the solver installed?

\item \code{solve_via_data}: Solve a problem represented by data returned from apply.

\item \code{reduction_solve}: Solve a problem represented by data returned from apply.

\item \code{solve_via_data}: Solve a problem represented by data returned from apply.
}}

