% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conic_solvers.R
\name{CPLEX_CONIC-class}
\alias{CPLEX_CONIC-class}
\alias{CPLEX_CONIC}
\alias{mip_capable,CPLEX_CONIC-method}
\alias{name,CPLEX_CONIC-method}
\alias{import_solver,CPLEX_CONIC-method}
\alias{accepts,CPLEX_CONIC,Problem-method}
\alias{status_map,CPLEX_CONIC-method}
\alias{perform,CPLEX_CONIC,Problem-method}
\alias{invert,CPLEX_CONIC,list,list-method}
\alias{solve_via_data,CPLEX_CONIC-method}
\title{An interface for the CPLEX solver}
\usage{
CPLEX_CONIC()

CPLEX_CONIC()

\S4method{mip_capable}{CPLEX_CONIC}(solver)

\S4method{name}{CPLEX_CONIC}(x)

\S4method{import_solver}{CPLEX_CONIC}(solver)

\S4method{accepts}{CPLEX_CONIC,Problem}(object, problem)

\S4method{status_map}{CPLEX_CONIC}(solver, status)

\S4method{perform}{CPLEX_CONIC,Problem}(object, problem)

\S4method{invert}{CPLEX_CONIC,list,list}(object, solution, inverse_data)

\S4method{solve_via_data}{CPLEX_CONIC}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache = list()
)
}
\arguments{
\item{solver, object, x}{A \linkS4class{CPLEX_CONIC} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{status}{A status code returned by the solver.}

\item{solution}{The raw solution returned by the solver.}

\item{inverse_data}{A list containing data necessary for the inversion.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance on the primal and dual residual.}

\item{reltol}{The relative tolerance on the duality gap.}

\item{abstol}{The absolute tolerance on the duality gap.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
An interface for the CPLEX solver
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable}: Can the solver handle mixed-integer programs?

\item \code{name}: Returns the name of the solver.

\item \code{import_solver}: Imports the solver.

\item \code{accepts}: Can CPLEX solve the problem?

\item \code{status_map}: Converts status returned by the CPLEX solver to its respective CVXPY status.

\item \code{perform}: Returns a new problem and data for inverting the new solution.

\item \code{invert}: Returns the solution to the original problem given the inverse_data.

\item \code{solve_via_data}: Solve a problem represented by data returned from apply.
}}

