% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conic_solvers.R
\docType{class}
\name{CVXOPT-class}
\alias{CVXOPT-class}
\alias{mip_capable,CVXOPT-method}
\alias{status_map,CVXOPT-method}
\alias{name,CVXOPT-method}
\alias{import_solver,CVXOPT-method}
\alias{accepts,CVXOPT,Problem-method}
\alias{perform,CVXOPT,Problem-method}
\alias{invert,CVXOPT,list,list-method}
\alias{solve_via_data,CVXOPT-method}
\title{An interface for the CVXOPT solver.}
\usage{
\S4method{mip_capable}{CVXOPT}(solver)

\S4method{status_map}{CVXOPT}(solver, status)

\S4method{name}{CVXOPT}(x)

\S4method{import_solver}{CVXOPT}(solver)

\S4method{accepts}{CVXOPT,Problem}(object, problem)

\S4method{perform}{CVXOPT,Problem}(object, problem)

\S4method{invert}{CVXOPT,list,list}(object, solution, inverse_data)

\S4method{solve_via_data}{CVXOPT}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache
)
}
\arguments{
\item{solver, object, x}{A \linkS4class{CVXOPT} object.}

\item{status}{A status code returned by the solver.}

\item{problem}{A \linkS4class{Problem} object.}

\item{solution}{The raw solution returned by the solver.}

\item{inverse_data}{A list containing data necessary for the inversion.}

\item{data}{Data generated via an apply call.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance on the primal and dual residual.}

\item{reltol}{The relative tolerance on the duality gap.}

\item{abstol}{The absolute tolerance on the duality gap.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
An interface for the CVXOPT solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable(CVXOPT)}: Can the solver handle mixed-integer programs?

\item \code{status_map(CVXOPT)}: Converts status returned by the CVXOPT solver to its respective CVXPY status.

\item \code{name(CVXOPT)}: Returns the name of the solver.

\item \code{import_solver(CVXOPT)}: Imports the solver.

\item \code{accepts(object = CVXOPT, problem = Problem)}: Can CVXOPT solve the problem?

\item \code{perform(object = CVXOPT, problem = Problem)}: Returns a new problem and data for inverting the new solution.

\item \code{invert(object = CVXOPT, solution = list, inverse_data = list)}: Returns the solution to the original problem given the inverse_data.

\item \code{solve_via_data(CVXOPT)}: Solve a problem represented by data returned from apply.

}}
