% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{LogDet-class}
\alias{LogDet-class}
\alias{.LogDet}
\alias{LogDet}
\alias{LogDet}
\alias{validate_args,LogDet-method}
\alias{to_numeric,LogDet-method}
\alias{size_from_args,LogDet-method}
\alias{sign_from_args,LogDet-method}
\alias{is_atom_convex,LogDet-method}
\alias{is_atom_concave,LogDet-method}
\alias{is_incr,LogDet-method}
\alias{is_decr,LogDet-method}
\alias{graph_implementation,LogDet-method}
\title{The LogDet class.}
\usage{
LogDet(A)

\S4method{validate_args}{LogDet}(object)

\S4method{to_numeric}{LogDet}(object, values)

\S4method{size_from_args}{LogDet}(object)

\S4method{sign_from_args}{LogDet}(object)

\S4method{is_atom_convex}{LogDet}(object)

\S4method{is_atom_concave}{LogDet}(object)

\S4method{is_incr}{LogDet}(object, idx)

\S4method{is_decr}{LogDet}(object, idx)

\S4method{graph_implementation}{LogDet}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{A}{An \linkS4class{Expression} or numeric matrix.}

\item{object}{A \linkS4class{LogDet} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
The natural logarithm of the determinant of a matrix, \eqn{\log\det(A)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Check that \code{A} is square.

\item \code{to_numeric}: The log-determinant of SDP matrix \code{A}. This is the sum of logs of the eigenvalues and is equivalent to the nuclear norm of the matrix logarithm of \code{A}.

\item \code{size_from_args}: The atom is a scalar.

\item \code{sign_from_args}: The atom is non-negative.

\item \code{is_atom_convex}: The atom is not convex.

\item \code{is_atom_concave}: The atom is concave.

\item \code{is_incr}: The atom is not monotonic in any argument.

\item \code{is_decr}: The atom is not monotonic in any argument.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{A}}{An \linkS4class{Expression} or numeric matrix.}
}}

