% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_kernel.R
\name{kernel_matern}
\alias{kernel_matern}
\title{Generating A Single Matrix-wise Function Using Matern}
\usage{
kernel_matern(l, p, sigma)
}
\arguments{
\item{l}{(numeric) A numeric number indicating the hyperparameter
(flexibility) of a specific kernel.}

\item{p}{(integer) For polynomial, p is the power; for matern, v = p + 1 /
2; for rational, alpha = p.}

\item{sigma}{(numeric) The covariance coefficient for neural network kernel.}
}
\value{
\item{matrix_wise}{(function) A function calculating the relevance
of two matrices.}
}
\description{
Generate matrix-wise functions for two matrices using matern kernel.
}
\details{
\bold{Matern Kernels}
\deqn{k_{Matern}(r)=\frac{2^{1-\nu}}{\Gamma(\nu)}\Big(\frac{\sqrt{2\nu
r}}{l}\Big)^\nu K_\nu \Big(\frac{\sqrt{2\nu r}}{l}\Big)}
}
\references{
The MIT Press. Gaussian Processes for Machine Learning, 2006.
}
\author{
Wenying Deng
}
