% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2dv_cube.R
\name{s2dv_cube}
\alias{s2dv_cube}
\title{Creation of a 's2dv_cube' object}
\usage{
s2dv_cube(
  data,
  coords = NULL,
  varName = NULL,
  metadata = NULL,
  Datasets = NULL,
  Dates = NULL,
  when = NULL,
  source_files = NULL,
  ...
)
}
\arguments{
\item{data}{A multidimensional array with named dimensions, typically with 
dimensions: dataset, member, sdate, ftime, lat and lon.}

\item{coords}{A list of named vectors with the coordinates corresponding to 
the dimensions of the data parameter. If any coordinate has dimensions, they 
will be set as NULL. If any coordinate is not provided, it is set as an 
index vector with the values from 1 to the length of the corresponding 
dimension. The attribute 'indices' indicates wether the coordinate is an 
index vector (TRUE) or not (FALSE).}

\item{varName}{A character string indicating the abbreviation of the variable 
name.}

\item{metadata}{A named list where each element is a variable containing the
corresponding information. The information can be contained in a list of 
lists for each variable.}

\item{Datasets}{Character strings indicating the names of the dataset. It 
there are multiple datasets it can be a vector of its names or a list of
lists with additional information.}

\item{Dates}{A POSIXct array of time dimensions containing the Dates.}

\item{when}{A time stamp of the date when the data has been loaded. This 
parameter is also found in Load() and Start() functions output.}

\item{source_files}{A vector of character strings with complete paths to all 
the found files involved in loading the data.}

\item{\dots}{Additional elements to be added in the object. They will be 
stored in the end of 'attrs' element. Multiple elements are accepted.}
}
\value{
The function returns an object of class 's2dv_cube' with the following 
elements in the structure:\cr
\itemize{
 \item{'data', array with named dimensions;}
 \item{'dims', named vector of the data dimensions;}
 \item{'coords', list of named vectors with the coordinates corresponding to 
 the dimensions of the data parameter;}
 \item{'attrs', named list with elements:
   \itemize{
     \item{'Dates', array with named temporal dimensions of class 'POSIXct' from 
     time values in the data;}
     \item{'Variable', has the following components:
       \itemize{
         \item{'varName', with the short name of the loaded variable as specified 
         in the parameter 'var';}
         \item{'metadata', named list of elements with variable metadata. 
               They can be from coordinates variables (e.g. longitude) or 
               main variables (e.g. 'var');}
       }
     }
     \item{'Datasets', character strings indicating the names of the dataset;}
     \item{'source_files', a vector of character strings with complete paths 
           to all the found files involved in loading the data;}
     \item{'when', a time stamp of the date issued by the Start() or Load() 
           call to obtain the data;}
     \item{'load_parameters', it contains the components used in the 
           arguments to load the data from Start() or Load() functions.}
   }
 }
}
}
\description{
This function allows to create an 's2dv_cube' object by passing 
information through its parameters. This function will be needed if the data 
hasn't been loaded using CST_Load or has been transformed with other methods. 
An 's2dv_cube' object has many different components including metadata. This 
function will allow to create 's2dv_cube' objects even if not all elements 
are defined and for each expected missed parameter a warning message will be 
returned.
}
\examples{
exp_original <- 1:100
dim(exp_original) <- c(lat = 2, time = 10, lon = 5)
exp1 <- s2dv_cube(data = exp_original)
class(exp1)
coords <- list(lon = seq(-10, 10, 5), lat = c(45, 50))
exp2 <- s2dv_cube(data = exp_original, coords = coords) 
class(exp2)
metadata <- list(tas = list(level = '2m'))
exp3 <- s2dv_cube(data = exp_original, coords = coords,
                 varName = 'tas', metadata = metadata)
class(exp3)
Dates = as.POSIXct(paste0(rep("01", 10), rep("01", 10), 1990:1999), format = "\%d\%m\%Y")
dim(Dates) <- c(time = 10)
exp4 <- s2dv_cube(data = exp_original, coords = coords,
                 varName = 'tas', metadata = metadata,
                 Dates = Dates)  
class(exp4)
exp5 <- s2dv_cube(data = exp_original, coords = coords,
                 varName = 'tas', metadata = metadata,
                 Dates = Dates, when = "2019-10-23 19:15:29 CET")  
class(exp5)
exp6 <- s2dv_cube(data = exp_original, coords = coords,
                 varName = 'tas', metadata = metadata,
                 Dates = Dates,
                 when = "2019-10-23 19:15:29 CET", 
                 source_files = c("/path/to/file1.nc", "/path/to/file2.nc"))
class(exp6)
exp7 <- s2dv_cube(data = exp_original, coords = coords,
                 varName = 'tas', metadata = metadata,
                 Dates = Dates,
                 when = "2019-10-23 19:15:29 CET", 
                 source_files = c("/path/to/file1.nc", "/path/to/file2.nc"),
                 Datasets = list(
                   exp1 = list(InitializationsDates = list(Member_1 = "01011990", 
                                                           Members = "Member_1"))))  
class(exp7)
dim(exp_original) <- c(dataset = 1, member = 1, time = 10, lat = 2, lon = 5)
exp8 <- s2dv_cube(data = exp_original, coords = coords,
                 varName = 'tas', metadata = metadata,
                 Dates = Dates, original_dates = Dates)  
class(exp8)
}
\seealso{
\code{\link[s2dv]{Load}} and \code{\link{CST_Load}}
}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}
}
