% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_AnalogsPredictors.R
\name{CST_AnalogsPredictors}
\alias{CST_AnalogsPredictors}
\title{AEMET Downscaling   
Precipitation and maximum and minimum temperature downscaling method 
based on analogs: synoptic situations and significant predictors.}
\usage{
CST_AnalogsPredictors(
  exp,
  slp,
  obs,
  lon,
  lat,
  slp_lon,
  slp_lat,
  var_name,
  hr_obs,
  tdates,
  ddates,
  restrain,
  dim_name_longitude = "lon",
  dim_name_latitude = "lat",
  dim_name_time = "time"
)
}
\arguments{
\item{exp}{List of arrays with downscaled period seasonal forecast data. The list 
has to contain model atmospheric variables (instantaneous 12h data) that must 
be indentify by parenthesis name.
For precipitation:
- u component of wind at 500 hPa (u500_mod) in m/s 
- v component of wind at 500 hPa (v500_mod) in m/s
- temperature at 500 hPa (t500_mod) in K
- temperature at 850 hPa (t850_mod) in K
- specific humidity at 700 hPa (q700_mod) in g/kg 
For temperature:
- u component of wind at 500 hPa (u500_mod) in m/s
- v component of wind at 500 hPa (v500_mod) in m/s
- temperature at 500 hPa (t500_mod) in K
- temperature at 700 hPa (t700_mod) in K 
- temperature at 850 hPa (t850_mod) in K
- specific humidity at 700 hPa (q700_mod) in g/kg 
- 2 meters temperature (tm2m_mod) in K
The arrays must have at least three dimensions with names 'lon', 'lat' and 'time'.
(lon = gridpoints of longitude, lat = gridpoints of latitude, time = number of downscaling days)
Seasonal forecast variables must have the same resolution and
domain as reanalysis variables ('obs' parameter, below).}

\item{slp}{Array with atmospheric seasonal forecast model sea level pressure
(instantaneous 12h data) that must be indentify as 'slp' (hPa). It has the same 
resolution as 'exp' and 'obs' paremeters but with an extended domain.
This domain contains extra degrees (most in the north and west part) compare to 
synoptic domain. The array must have at least three dimensions 
with names 'lon', 'lat' and 'time'.}

\item{obs}{List of arrays with training period reanalysis data. 
The list has to contain reanalysis atmospheric variables (instantaneous 
12h data) that must be indentify by parenthesis name.
For precipitation:
- u component of wind at 500 hPa (u500) in m/s 
- v component of wind at 500 hPa (v500) in m/s
- temperature at 500 hPa (t500) in K
- temperature at 850 hPa (t850) in K
- sea level pressure (slp) in hPa
- specific humidity at 700 hPa (q700) in g/kg 
For maximum and minimum temperature:
- u component of wind at 500 hPa (u500) in m/s 
- v component of wind at 500 hPa (v500) in m/s
- temperature at 500 hPa (t500) in K
- temperature at 700 hPa (t700) in K
- temperature at 850 hPa (t850) in K
- sea level pressure (slp) in hPa
- specific humidity at 700 hPa (q700) in g/kg 
- 2 meters temperature (tm2m) in K
The arrays must have at least three dimensions with names 'lon', 'lat' and 'time'.}

\item{lon}{Vector of the synoptic longitude (from (-180º) to 180º), 
The vector must go from west to east. The same as for the training function.}

\item{lat}{Vector of the synoptic latitude. The vector must go from north to south.
The same as for the training function.}

\item{slp_lon}{Vector of the extended longitude (from (-180º) to 180º), 
The vector must go from west to east. The same as for the training function.}

\item{slp_lat}{Vector of the extended latitude. The vector must go from north to south.
The same as for the training function.}

\item{var_name}{Variable name to downscale. There are two options: 'prec' for
precipitation and 'temp' for maximum and minimum temperature.}

\item{hr_obs}{Local path of HR observational files (maestro and pcp/tmx-tmn). 
For precipitation can be downloaded from http://www.aemet.es/documentos/es/serviciosclimaticos/cambio_climat/datos_diarios/dato_observacional/rejilla_5km/v2/Serie_AEMET_v2_pcp_1951a202006_txt.tar.gz   
For maximum and minimum temperature can be downloaded from http://www.aemet.es/documentos/es/serviciosclimaticos/cambio_climat/datos_diarios/dato_observacional/rejilla_5km/temperatura/v1/tmax/Serie_AEMET_v1_tmax_1951a202006_txt.tar.gz and http://www.aemet.es/documentos/es/serviciosclimaticos/cambio_climat/datos_diarios/dato_observacional/rejilla_5km/temperatura/v1/tmin/Serie_AEMET_v1_tmin_1951a202006_txt.tar.gz respetively.
Maestro file (maestro_red_hr_SPAIN.txt) has gridpoint (nptos), longitude (lon), latitude (lat) and 
altitude (alt) in columns (vector structure).
Data file (pcp/tmx/tmn_red_SPAIN_1951-201903.txt) includes 5km resolution spanish daily data 
(precipitation or maximum and minimum temperature from january 1951 to june 2020. See README 
file for more information.
IMPORTANT!: HR observational period must be the same as for reanalysis variables.
It is assumed that the training period is smaller than the HR original one (1951-2019), so it is 
needed to make a new ascii file with the new period and the same structure as original, 
specifying the training dates in the name (e.g. 'pcp_red_SPAIN_19810101-19961231.txt' for 
'19810101-19961231' period).}

\item{tdates}{Training period dates in format YYYYMMDD(start)-YYYYMMDD(end) 
(e.g. 19810101-20181231).}

\item{ddates}{Downscaling period dates in format YYYYMMDD(start)-YYYYMMDD(end) (e.g. 20191001-20200331).}

\item{restrain}{Output (list of matrix) obtained from 'training_analogs' function. 
For precipitation, 'restrain' object must contains um, vm, nger, gu92, gv92, 
gu52, gv52, neni, vdmin, vref, ccm, lab_pred and cor_pred variables. 
For maximum and minimum temperature, 'restrain' object must contains um, vm, 
insol, neni, vdmin y vref. See 'AnalogsPred_train.R' for more information.}

\item{dim_name_longitude}{A character string indicating the name of the longitude 
dimension, by default 'longitude'.}

\item{dim_name_latitude}{A character string indicating the name of the latitude 
dimension, by default 'latitude'.}

\item{dim_name_time}{A character string indicating the name of the time 
dimension, by default 'time'.}
}
\value{
Matrix with seasonal forecast precipitation (mm) or
maximum and minimum temperature (dozens of ºC) in a 5km x 5km regular grid 
over peninsular Spain and Balearic Islands. The resulted matrices have two
dimensions ('ddates' x 'nptos').(ddates = number of downscaling days
and nptos = number of 'hr_obs' gridpoints).
}
\description{
This function downscales low resolution precipitation data (e.g. from 
Seasonal Forecast Models) through the association with an observational high 
resolution (HR) dataset (AEMET 5 km gridded data of daily precipitation (Peral et al., 2017))
and a collection of predictors and past synoptic situations similar to estimated day. 
The method uses three domains: 
- peninsular Spain and Balearic Islands domain (5 km resolution): HR precipitation 
  and the downscaling result domain. 
- synoptic domain (low resolution, e.g. 1.5º x 1.5º): it should be centered over Iberian Peninsula 
  and cover enough extension to detect as much synoptic situations as possible.  
- extended domain (low resolution, e.g. 1.5º x 1.5º): it should have the same resolution
as synoptic domain. It is used for SLP Seasonal Forecast Models.
}
\author{
Marta Dominguez Alonso - AEMET, \email{mdomingueza@aemet.es}

Nuria Perez-Zanon - BSC, \email{nuria.perez@bsc.es}
}
