% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tools.R, R/transformfunction.R
\name{tool}
\alias{tool}
\alias{ztrans}
\alias{lpl}
\alias{g}
\alias{cntcov}
\alias{sampleQ}
\alias{getthres}
\alias{get.bound}
\alias{pu}
\alias{pu_inv}
\alias{normalize}
\alias{logitinv}
\alias{my_logit}
\alias{my_surv}
\alias{prev_fit_cste}
\title{tool functions}
\usage{
ztrans(z, x, x0, h)

lpl(input, x, x0, R, z, s, h)

g(x0, sep, sloped)

cntcov(l, beta0, beta0dot, g0dot, x, x0, R, Z, s, h, sep, sloped)

sampleQ(i, l, stdel, stgam, std, x, R, Z, s, h, sep, sloped, m)

getthres(alpha, l, stdel, stgam, std, x, R, Z, s, h, sep, sloped, m)

get.bound(thres, l, stdel, stgam, std, x, R, Z, s, h, sep, sloped)

pu(x, beta)

pu_inv(x, beta, u)

normalize(x)

logitinv(x)

my_logit(x, y, off = NULL, beta = NULL, lam = 0, pen = 2)

my_surv(x, y, atrisk, off = NULL, beta = NULL, lam = 0)

prev_fit_cste(u1, u2, fit)
}
\arguments{
\item{z}{treatment indicators which is \eqn{n*K} matrix.}

\item{x}{numeric vector or matrix.}

\item{x0}{biomarkers at a fixed point.}

\item{h}{kernel bandwidth.}

\item{input}{parameters with dimension (2*K+1).}

\item{R}{indicator matrix of individuals at risk prior to \eqn{y_i}.}

\item{s}{censoring indicator which is a \eqn{n*1} vector.}

\item{sloped}{the first derivative of \eqn{g}.}

\item{l}{contraction vector with dimension \eqn{K}.}

\item{beta0, beta0dot}{the value of beta and its first derivative at \eqn{x0}.}

\item{g0dot}{the first derivative of \eqn{g0} at x0.}

\item{i}{the \eqn{i}-th observation.}

\item{stdel, stgam, std}{store the values of \code{beta0}, \code{beta0dot},
and \code{godot} at each \eqn{x_i}.}

\item{m}{number of turns of resampling.}

\item{alpha}{the (1-alpha)-confidence level of SCB.}

\item{thres}{the output of \code{getthres} function.}

\item{y, u, u1, u2, beta, atrisk}{numeric vector.}

\item{off}{numeric value, offset.}

\item{lam}{numeric value, penalty parameter.}

\item{pen}{hyper-parameter that used in MCP and SCAD penalty functions.}

\item{fit}{a S3 class of cste.}

\item{seq}{parameter for trapezoid rule.}
}
\value{
Intermediate results.

Intermediate results.
}
\description{
tool functions

tool functions
}
\keyword{internal}
