% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designCRT.R
\name{CRTpower}
\alias{CRTpower}
\title{Power and sample size calculations for a CRT}
\usage{
CRTpower(
  trial = NULL,
  locations = NULL,
  alpha = 0.05,
  desiredPower = 0.8,
  effect = NULL,
  yC = NULL,
  outcome_type = "d",
  sigma2 = NULL,
  phi = 1,
  N = 1,
  ICC = NULL,
  k = NULL,
  sd_h = 0
)
}
\arguments{
\item{trial}{dataframe or \code{'CRTsp'} object containing Cartesian coordinates of locations in columns 'x' and 'y'.}

\item{locations}{numeric: total number of units available for randomization (required if \code{trial} is not specified)}

\item{alpha}{numeric: confidence level}

\item{desiredPower}{numeric: desired power}

\item{effect}{numeric: required effect size}

\item{yC}{numeric: baseline value of outcome}

\item{outcome_type}{character with options -
\code{'y'}: continuous;
\code{'n'}: count;
\code{'e'}: event rate;
\code{'p'}: proportion;
\code{'d'}: dichotomous.}

\item{sigma2}{numeric: variance of the outcome (required for \code{outcome_type = 'y'})}

\item{phi}{numeric: overdispersion parameter (for \code{outcome_type = 'n'} or \code{outcome_type = 'e'})}

\item{N}{numeric: mean of the denominator for proportions (for \code{outcome_type = 'p'})}

\item{ICC}{numeric: Intra-Cluster Correlation}

\item{k}{integer: number of clusters in each arm (required if \code{trial} is not specified)}

\item{sd_h}{standard deviation of number of units per cluster (required if \code{trial} is not specified)}
}
\value{
A list of class \code{'CRTsp'} object comprising the input data, cluster and arm assignments,
trial description and results of power calculations
}
\description{
\code{CRTpower} carries out power and sample size calculations for CRTs.
}
\details{
Power and sample size calculations are for a two-arm trial using the formulae of
\href{https://bmcmedresmethodol.biomedcentral.com/articles/10.1186/1471-2288-11-102}{Hemming et al, 2011} which use a
normal approximation for the inter-cluster variation. For counts
or event rate data a quasi–Poisson model is assumed. The functions do not consider any loss
in power due to contamination, loss to follow-up etc.
If geolocations are not input power and sample size calculations are based on the scalar input parameters.\cr\cr
If a trial dataframe or \code{'CRTsp'} object containing a pre-existing randomization is input then the
numbers and sizes of clusters are in the input data are used to estimate the power. If buffer zones have been specified
then separate calculations are made for the core area and for the full site\cr
The output is an object of class \code{'CRTsp'} containing any input trial data.frame and values for:
\itemize{
\item The required numbers of clusters to achieve the specified power.
\item The design effect based on the input ICC.
\item Calculations of the nominal power (ignoring any bias caused by contamination effects)\cr
}
}
\examples{
{# Example without input geolocations
examplePower1 = CRTpower(locations = 3000, ICC=0.10, effect=0.4, alpha = 0.05,
    outcome_type = 'd', desiredPower = 0.8, yC=0.35, k = 20, sd_h=5)
summary(examplePower1)
# Example with input geolocations and randomisation
examplePower2 = CRTpower(trial = readdata('example_site.csv'), desiredPower = 0.8,
    effect=0.4, yC=0.35, outcome_type = 'd', ICC = 0.05, k = 20)
summary(examplePower2)
}
}
