% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointTests.R
\name{HS.test}
\alias{HS.test}
\title{Hidalgo-Seo Test}
\usage{
HS.test(x, corr = TRUE, stat_plot = FALSE)
}
\arguments{
\item{x}{Data to test for change in mean}

\item{corr}{If \code{TRUE}, the long-run variance will be computed under the
assumption of correlated residuals; ignored if \code{custom_var}
is not \code{NULL} or \code{use_kernel_var} is \code{TRUE}}

\item{stat_plot}{Whether to create a plot of the values of the statistic at
all potential change points}
}
\value{
A \code{htest}-class object containing the results of the test
}
\description{
Performs the (univariate) Hidalgo-Seo test for change in mean, as described
in \insertCite{horvathricemiller19}{CPAT}. This is effectively an interface
to \code{\link{stat_hs}}; see its documentation for more details. p-values
are computed using \code{\link{phidalgo_seo}}, which represents the limiting
distribution of the test statistic when the null hypothesis is true.
}
\examples{
HS.test(rnorm(1000))
HS.test(rnorm(1000), corr = FALSE)
}
\references{
\insertAllCited{}
}
