\name{choose_lambda}
\alias{choose_lambda}
\title{Choose the most appropriate weight parameter lambda}
\description{Randomly sample a large number of subnetworks 
with the same size as the ones chosen by the five different 
lambda values to get the null distribution of the scores of
subnetworks corresponding to different size and lambda, in 
order to get the adjusted scores for the chosen subnetworks,
and choose the lambda giving rise to the highest scored sub-network}
\usage{
choose_lambda(diff_expr, diff_coex, lambda, subnet_size, 
num_random_sampling, best_score)
}
\arguments{
  \item{diff_expr}{A vector storing the F-statistics measuring 
                  the differential expression of each gene, which 
                  length equals the number of genes N}
  \item{diff_coex}{An N by N matrix with entry (i,j) corresponding 
                  to the ECF-statistics of gene pair (i,j), which 
                  measures the differential correlation between genes i and j}
  \item{lambda}{A numeric vector of length 5 which stores the five 
                quantiles of weight parameter lambda}
  \item{subnet_size}{A numeric vector of length 5 which stores the size of 
                    subnetworks selected using different weight 
                    parameter lambda}
  \item{num_random_sampling}{the number of random subnetworks 
                 to be sampled for each lambda in order to get 
                 the null distribution}
  \item{best_score}{the best scores of the five sub-networks selected 
                    using genetic algorithm}
}

\value{
  A list containing:
  \item{Adj_score}{The adjusted scores of the five selected sub-networks 
    according to the null distribution generated by random sampling}
  \item{best_lambda}{The lambda giving rise to the sub-network 
                      with the highest adjusted score}
  \item{Random_Score}{The matrix storing the null score distribution 
                       of random subnetworks}
}
\author{Haisu Ma}

\examples{

data(set1_scaled_diff)
data(set1_GA)

set1_quantile<-get_quantiles(diff_expr=set1_scaled_diff[[1]],
diff_coex=set1_scaled_diff[[2]],klist=c(20,25),pop_size=20)

lambda<-set1_quantile[[2]]

set1_choose_lambda <- choose_lambda(diff_expr=set1_scaled_diff[[1]],
diff_coex=set1_scaled_diff[[2]],lambda,subnet_size=set1_GA$Subnet_size,
num_random_sampling=10,best_score=set1_GA$Best_Scores)

}