% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONDOP.R
\name{train.RFs}
\alias{train.RFs}
\title{Train and validate the operon classifier and evaluate the feature importance.}
\usage{
train.RFs(data, class, run = 30, p = 0.9, ntr = 1000, mtree = 4,
  verbose = TRUE, ...)
}
\arguments{
\item{data}{Training/test data. See \code{select.ops} and \code{select.nops}.}

\item{class}{Vector of the class labels.}

\item{run}{Number of runs of training/validation. Default values is 30.}

\item{p}{Percentage of samples to be used for the training. Default values is 0.9.}

\item{ntr}{Number of trees to use in the operon classifier. Default values is 1000.}

\item{mtree}{Number of variables randomly sampled as candidates at each split in each tree. Default values is 4.}

\item{verbose}{Default logical value is TRUE.}
}
\description{
Internal function to train an operon classifier to distinguish operon pairs (OPs) from non-operon pairs (NOPs)
on a given RNA-seq expression profile.
}
\author{
Vittorio Fortino
}
\keyword{internal}

