\name{clusterRange}
\alias{clusterRange}
\title{
COMMUNAL convenience harness
}
\description{
Convenience harness to run COMMUNAL on a range of inputs, for a fixed set of parameters. The columns are the points to be clustered. The goal is to reduce the dimensionality of the data points, and try clustering with a varying number of dimensions. The rows are (optionally) first sorted by variance. The top \code{x} rows are used for clustering by \code{\link{COMMUNAL}}, for each \code{x} in \code{varRange}.
Output is used by \code{\link{plotRange3D}} to generate 3D plot.
}
\usage{
clusterRange(dataMtx, varRange, ...)
}
\arguments{
  \item{dataMtx}{
The data for input to \code{\link{COMMUNAL}}.
}
  \item{varRange}{
Numeric vector of how many items of data matrix to cluster.
\code{clusterRange} runs \code{\link{COMMUNAL}} on the x rows (dimensions) with the highest variance
for each element x in \code{varRange}.
}
  \item{\dots}{
Arguments to pass down to \code{\link{COMMUNAL}}. If \code{reorder=FALSE} is specified, then the rows will not be first sorted by variance in this function, and the rows will be taken in the given order. By default, rows are sorted by variance.
}
}
\value{
 \item{all.results}{
list of \code{\linkS4class{COMMUNAL}} objects, one for each range in \code{varRange}
}
 \item{varRange}{
the \code{varRange} input parameter
}
}
\author{
Albert Chen and Timothy E Sweeney\cr
Maintainer: Albert Chen acc2015@stanford.edu
}
\examples{
\dontrun{
## To identify k, use clusterRange and plotRange3D to visualize validation measures
data(BRCA.100) # 533 tissues to cluster, with measurements of 100 genes each
varRange <- c(50, 75, 100)
clus.methods <- c("hierarchical", "kmeans")
validation <- c('wb.ratio', 'dunn', 'avg.silwidth')
range.results <- clusterRange(BRCA.100, varRange, ks=2:5, clus.methods=clus.methods,
                              validation=validation)
plot.data <- plotRange3D(range.results, ks=2:5, clus.methods, validation)
## Note: the BRCA.results dataset was generated by running clusterRange on 
## a larger range than the one here (with a larger input dataset)
}
}