% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBO_data.R
\name{COMBO_data}
\alias{COMBO_data}
\title{Generate Data to use in COMBO Functions}
\usage{
COMBO_data(sample_size, x_mu, x_sigma, z_shape, beta, gamma)
}
\arguments{
\item{sample_size}{An integer specifying the sample size of the generated data set.}

\item{x_mu}{A numeric value specifying the mean of \code{x} predictors
generated from a Normal distribution.}

\item{x_sigma}{A positive numeric value specifying the standard deviation of
\code{x} predictors generated from a Normal distribution.}

\item{z_shape}{A positive numeric value specifying the shape parameter of
\code{z} predictors generated from a Gamma distribution.}

\item{beta}{A column matrix of \eqn{\beta} parameter values (intercept, slope)
to generate data under in the true outcome mechanism.}

\item{gamma}{A numeric matrix of \eqn{\gamma} parameters
to generate data under in the observation mechanism.
In matrix form, the \code{gamma} matrix rows correspond to intercept (row 1)
and slope (row 2) terms. The gamma parameter matrix columns correspond to the true outcome categories
\eqn{Y \in \{1, 2\}}.}
}
\value{
\code{COMBO_data} returns a list of generated data elements:
\item{obs_Y}{A vector of observed outcomes.}
\item{true_Y}{A vector of true outcomes.}
\item{obs_Y_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row contains
exactly one 0 entry and exactly one 1 entry.}
\item{x}{A vector of generated predictor values in the true outcome
mechanism, from the Normal distribution.}
\item{z}{A vector of generated predictor values in the observation
mechanism from the Gamma distribution.}
\item{x_design_matrix}{The design matrix for the \code{x} predictor.}
\item{z_design_matrix}{The design matrix for the \code{z} predictor.}
}
\description{
Generate Data to use in COMBO Functions
}
\examples{
set.seed(123)
n <- 500
x_mu <- 0
x_sigma <- 1
z_shape <- 1

true_beta <- matrix(c(1, -2), ncol = 1)
true_gamma <- matrix(c(.5, 1, -.5, -1), nrow = 2, byrow = FALSE)

my_data <- COMBO_data(sample_size = n,
                      x_mu = x_mu, x_sigma = x_sigma,
                      z_shape = z_shape,
                      beta = true_beta, gamma = true_gamma)
table(my_data[["obs_Y"]], my_data[["true_Y"]])
}
