% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_sensitivity.R
\name{plotSARanks}
\alias{plotSARanks}
\title{Plot ranks from an uncertainty/sensitivity analysis}
\usage{
plotSARanks(SAresults, plot_units = NULL, order_by = "nominal")
}
\arguments{
\item{SAresults}{A list of sensitivity/uncertainty analysis results from \code{\link[=sensitivity]{sensitivity()}}.}

\item{plot_units}{A character vector of units to plot. Defaults to all units. You can also set
to \code{"top10"} to only plot top 10 units, and \code{"bottom10"} for bottom ten.}

\item{order_by}{If set to \code{"nominal"}, orders the rank plot by nominal ranks
(i.e. the original ranks prior to the sensitivity analysis). Otherwise if \code{"median"}, orders by
median ranks.}
}
\value{
A plot of rank confidence intervals, generated by 'ggplot2'.
}
\description{
Plots the ranks resulting from an uncertainty and sensitivity analysis, in particular plots
the median, and 5th/95th percentiles of ranks.
}
\details{
To use this function you first need to run \code{\link[=sensitivity]{sensitivity()}}. Then enter the resulting list as the
\code{SAresults} argument here. See \href{https://bluefoxr.github.io/COINrDoc/sensitivity-analysis.html}{COINr online documentation}
for more details.
}
\examples{
\donttest{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()

# define noise to be applied to weights
nspecs <- data.frame(AgLevel = c(2,3), NoiseFactor = c(0.25,0.25))

# create list specifying assumptions to vary and alternatives
SAspecs <- list(
  impute = list(imtype = c("indgroup_mean", "ind_mean", "none")),
  normalise = list(ntype = c("minmax", "rank", "dist2max")),
  weights = list(NoiseSpecs = nspecs, Nominal = "Original")
)

# run uncertainty analysis
# here we set N deliberately much lower than normal to enable quick testing
# Would recommend in a practical case to increase to perhaps 500 (more is always better)
SAresults <- sensitivity(ASEM, v_targ = "Index",
                         SA_specs = SAspecs,
                         N = 20,
                         SA_type = "UA")

# plot rank intervals
plotSARanks(SAresults)
}

}
\seealso{
\itemize{
\item \code{\link[=sensitivity]{sensitivity()}} Perform global sensitivity or uncertainty analysis on a COIN
\item \code{\link[=plotSA]{plotSA()}} Plot sensitivity indices following a sensitivity analysis.
}
}
