% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_preanalyse.R
\name{getStats}
\alias{getStats}
\title{Get table of indicator statistics for any data set}
\usage{
getStats(
  COIN,
  icodes = NULL,
  dset = "Raw",
  out2 = "COIN",
  cortype = "pearson",
  t_skew = 2,
  t_kurt = 3.5,
  t_colin = 0.9,
  t_denom = 0.7,
  t_missing = 65,
  IQR_coef = 1.5
)
}
\arguments{
\item{COIN}{A COIN object or data frame of indicator data}

\item{icodes}{A character vector of indicator names to analyse. Defaults to all indicators.}

\item{dset}{The data set to analyse.}

\item{out2}{Where to output the results: if \code{"COIN"} (default), appends to the COIN, otherwise if \code{"list"}, outputs to a separate list.}

\item{cortype}{The type of correlation to calculate, either \code{"pearson"}, \code{"spearman"}, or \code{"kendall"}. See \link[stats:cor]{stats::cor}.}

\item{t_skew}{Skewness threshold.}

\item{t_kurt}{Kurtosis threshold.}

\item{t_colin}{Collinearity threshold (absolute value of correlation).}

\item{t_denom}{High correlation with denominator threshold.}

\item{t_missing}{Missing data threshold, in percent.}

\item{IQR_coef}{Interquartile range coefficient, used for identifying outliers.}
}
\value{
If \code{out2 = "COIN"} (default), results are appended to the COIN in \code{.$Analysis}, otherwise if \code{out2 = "list"}, outputs to a separate list.
In both cases, the result is a list containing:
\itemize{
\item A data frame of statistics for each indicator column
\item A data frame indicating which points may be considered outliers according to the interquartile range
\item A data frame of correlations between indicators
\item A data frame of correlations between indicators and any denominators present in \code{.$Input$Denominators}
}
}
\description{
Takes a COIN or data frame and returns a table of statistics for each column, including max, min, median, mean, standard deviation, kurtosis, etc.
Flags indicators with possible outliers, and checks for collinearity with other indicators and denominators (if any).
Also checks number of unique values and percentage of zeros. Also returns correlation matrices and a table of outliers,
as a list.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# get list of stats from raw data set
stat_list <- getStats(ASEM, dset = "Raw", out2 = "list")

}
