\name{CNull-package}
\alias{CNull-package}
\alias{CNull}
\docType{package}
\title{
CNull: Fast Algorithms for Frequency-Preserving Null Models in Ecology
}
\description{ A package that speeds up statistical analysis requiring shuffling columns on big matrix data.
             The package provides functions for faster computation of diversity measure statistics
             when independent random shuffling is applied to the columns of a given matrix. 
             Given a diversity measure f and a matrix M, the provided functions can generate random samples 
             (shuffled matrix rows of M), the mean and variance of f, and the p-values of this measure 
             for two different null models that involve independent random shuffling of the columns of M.
             The package supports computations of alpha and beta diversity measures.
 }
\details{
\tabular{ll}{
Package: \tab CNull\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2017-3-1\cr
License: \tab GPL-3 \cr
}
The package considers two different null models for shuffling a matrix M; we call the first model 
the \emph{permutation} model (mentioned as SIM2 by Gotelli, Gotelli 2000). In this model, 
a matrix is shuffled by permuting the entries
of each column in M independently, with uniform probability among all possible permutations.
In the second model, the \emph{individual-based} model (Stegen et al. 2013), the entries of each column in M are summed up,
and then the column sum is distributed among the entries of the column. Both null models have been proven
to be symmetric for every row in M (Tsirogiannis et al.); for any two rows i and j in M and 
a given alpha-diversity measure f, 
the values f(i) and f(j) have exactly the same distribution when the elements in M are perturbed according
to one of the models described above.

The current package provides functions that implement the two described null models in a very efficient manner,
which allows for processing very large matrix data even on standard computers. 
Given a matrix M, a measure f, and a number r of desired random repetitions, the package functions 
can compute the following for each of the described null models:

\itemize{
\item A set of r random values for f generated by shuffling M according to one of the null models.

\item The mean and variance of f.

\item The p-values of f on M. 

\item A set of random rows generated from M according to one of the supported null models.
}

The package provides one function for each of the above problems, and for each of the described null models.
The package provides functions both for alpha and beta diversity measures.    
}
\author{ Constantinos Tsirogiannis and Adrija Kalvisa

Maintainer: Constantinos Tsirogiannis <tsirogiannis.c@gmail.com>
}
\references{
Gotelli, N. J., 2000. Null Model Analysis of Species Co-Occurrence Patterns. Ecology, 81(9), pp.2606-2621.

Stegen, J. C., Freestone, A. L., Crist, T. O., Anderson, M. J., Chase, J. M., Comita, L. S., Cornell, H. V., Davies, K. F., Harrison, S. P., Hurlbert, A. H., Inouye, B. D., Kraft, N. J. B., Myers, J. A., Sanders, N. J., Swenson, N. G., Vellend, M. (2013), Stochastic and Deterministic Drivers of Spatial and Temporal Turnover in Breeding Bird Communities. Global Ecology and Biogeography, 22:202-212.

Tsirogiannis, C., A. Kalvisa, B. Sandel and T. Conradi. Column-Shuffling Null Models Are Simpler Than You Thought. To appear.
}
\keyword{null model}
\keyword{biodiversity}
\keyword{ecology}
\keyword{statistics}
\examples{
#In the next example null-model calculations are
#performed using a function of phylogenetic diversity.
#Hence, we first load the required packages.
require(CNull)
require(ape)
require(PhyloMeasures)

#Load phylogenetic tree of bird families from package "ape"
data(bird.families, package = "ape")

#Create 100 random communities with 50 families each
comm = matrix(0,nrow = 100,ncol = length(bird.families$tip.label))
for(i in 1:nrow(comm)) {comm[i,sample(1:ncol(comm),50)] = 1}
colnames(comm) = bird.families$tip.label

#Set function f to be the Phylogenetic Diversity measure (PD)
#as defined in the R package PhyloMeasures.
my.f = function(mt,args){ return (pd.query(args[[1]],mt))}

# This function takes one extra argument, which is a phylogenetic tree.
# Hence, create a list whose only element is the desired tree.
arguments = list()
arguments[[1]] = bird.families

# Calculate the mean and variance of f in the permutation null
# model using 1000 Monte Carlo randomizations
permutation.moments.a(comm,f=my.f,args=arguments,reps=2000)
}
