% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_future_transformer_30_60kv.R
\name{pof_future_transformer_30_60kv}
\alias{pof_future_transformer_30_60kv}
\title{Future Probability of Failure for 30/10kV and 60/10kV Transformers}
\usage{
pof_future_transformer_30_60kv(
  transformer_type = "60kV Transformer (GM)",
  year_of_manufacture,
  utilisation_pct = "Default",
  no_taps = "Default",
  placement = "Default",
  altitude_m = "Default",
  distance_from_coast_km = "Default",
  corrosion_category_index = "Default",
  age_tf,
  age_tc,
  partial_discharge_tf = "Default",
  partial_discharge_tc = "Default",
  temperature_reading = "Default",
  main_tank = "Default",
  coolers_radiator = "Default",
  bushings = "Default",
  kiosk = "Default",
  cable_boxes = "Default",
  external_tap = "Default",
  internal_tap = "Default",
  mechnism_cond = "Default",
  diverter_contacts = "Default",
  diverter_braids = "Default",
  moisture = "Default",
  acidity = "Default",
  bd_strength = "Default",
  hydrogen = "Default",
  methane = "Default",
  ethylene = "Default",
  ethane = "Default",
  acetylene = "Default",
  hydrogen_pre = "Default",
  methane_pre = "Default",
  ethylene_pre = "Default",
  ethane_pre = "Default",
  acetylene_pre = "Default",
  furfuraldehyde = "Default",
  reliability_factor = "Default",
  k_value = 0.454,
  c_value = 1.087,
  normal_expected_life_tf = "Default",
  normal_expected_life_tc = "Default",
  simulation_end_year = 100
)
}
\arguments{
\item{transformer_type}{String. A sting that refers to the specific
asset category.
Options:
\code{transformer_type =
c("30kV Transformer (GM)", "60kV Transformer (GM)")}. The default setting is
\code{transformer_type = "60kV Transformer (GM)"}}

\item{year_of_manufacture}{Numeric. Normal expected life depends on the
year for manufacture.}

\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{no_taps}{Numeric. Average number of daily taps (tapchanger).}

\item{placement}{String. Specify if the asset is located outdoor or indoor.}

\item{altitude_m}{Numeric. Specify the altitude location for
the asset measured in meters from sea level.\code{altitude_m}
is used to derive the altitude factor. A setting of \code{"Default"}
will set the altitude factor to 1 independent of \code{asset_type}.}

\item{distance_from_coast_km}{Numeric. Specify the distance from the
coast measured in kilometers. \code{distance_from_coast_km} is used
to derive the distance from coast factor. A setting of \code{"Default"} will set the
 distance from coast factor to 1 independent of \code{asset_type}.}

\item{corrosion_category_index}{Integer.
Specify the corrosion index category, 1-5.}

\item{age_tf}{Numeric. The current age in years
of the transformer.}

\item{age_tc}{Numeric. The current age in years
of the tapchanger}

\item{partial_discharge_tf}{String. Indicating the
level of partial discharge in the transformer.
Options:
\code{partial_discharge_tf = c("Low", "Medium", "High (Not Confirmed)",
 "High (Confirmed)", "Default")}.}

\item{partial_discharge_tc}{String. Indicating the
level of partial discharge in the tapchanger
Options:
\code{partial_discharge_tc = c("Low", "Medium", "High (Not Confirmed)",
 "High (Confirmed)", "Default")}.}

\item{temperature_reading}{String. Indicating the criticality.
Options:
\code{temperature_reading = c("Normal", "Moderately High",
"Very High", "Default")}.}

\item{main_tank}{String. Indicating the observed condition of the
main tank. Options:
\code{main_tank = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.
in CNAIM (2021).}

\item{coolers_radiator}{String. Indicating the observed condition of the
coolers/radiators. Options:
\code{coolers_radiator = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.
in CNAIM (2021).}

\item{bushings}{String. Indicating the observed condition of the
bushings. Options:
\code{bushings = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.}

\item{kiosk}{String. Indicating the observed condition of the
kiosk. Options:
\code{kiosk = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.}

\item{cable_boxes}{String. Indicating the observed condition of the
cable boxes. Options:
\code{cable_boxes = c("No Deterioration","Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.}

\item{external_tap}{String. Indicating the observed external condition of the
 tapchanger. Options:
\code{external_tap = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.
in CNAIM (2021).}

\item{internal_tap}{String. Indicating the observed internal condition of the
 tapchanger. Options:
\code{external_tap = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.
in CNAIM (2021).}

\item{mechnism_cond}{String. Indicating the observed condition of the
 drive mechnism. Options:
\code{mechnism_cond = c("No deterioration", "Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.
in CNAIM (2021).}

\item{diverter_contacts}{String. Indicating the observed condition of the
selector and diverter contacts. Options:
\code{diverter_contacts = c("No deterioration", "Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.
in CNAIM (2021).}

\item{diverter_braids}{String. Indicating the observed condition of the
selector and diverter braids. Options:
\code{diverter_braids = c("No deterioration", "Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}.}

\item{moisture}{Numeric. the amount of moisture given in (ppm) See page 162, table 203 in CNAIM (2021).}

\item{acidity}{Numeric. the amount of acidicy given in (mg KOH/g) See page 162, table 204 in CNAIM (2021).}

\item{bd_strength}{Numeric. the amount of breakdown strength given in (kV) See page 162, table 205 in CNAIM (2021).}

\item{hydrogen}{Numeric. Refers to the hydrogen level in the
transformer oil. Hydrogen levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{methane}{Numeric. Refers to the methane level in the
transformer oil. Methane levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethylene}{Numeric. Refers to the ethylene level in the
transformer oil. Ethylene levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethane}{Numeric. Refers to the ethane level in the
transformer oil. Ethane levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{acetylene}{Numeric. Refers to the acetylene level in the
transformer oil. Acetylene levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{hydrogen_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{methane_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethylene_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethane_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{acetylene_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{furfuraldehyde}{Numeric. Refers to the furfuraldehyde level in the
transformer oil. furfuraldehyde levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}

\item{k_value}{Numeric. \code{k_value = "0.0454"} by default. This number is
given in a percentage. The default value is accordingly to the CNAIM standard
on p. 110.}

\item{c_value}{Numeric. \code{c_value = 1.087} by default.
The default value is accordingly to the CNAIM standard see page 110}

\item{normal_expected_life_tf}{Numeric. \code{normal_expected_life_tf = "Default"} by default.
The default value is accordingly to the CNAIM standard on page 107.}

\item{normal_expected_life_tc}{Numeric. \code{normal_expected_life_tc = "Default"} by default.
The default value is accordingly to the CNAIM standard on page 107.}

\item{simulation_end_year}{Numeric. The last year of simulating probability
of failure. Default is 100.}
}
\value{
Numeric. Future probability of failure.
}
\description{
This function calculates the future
annual probability of failure for 30/10kV and 60/10kV transformers.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function.
}
\examples{
# Future probability of failure for a 60/10kV transformer
}
