% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pnbd_LL}
\alias{pnbd_LL}
\alias{pnbd_nocov_LL_ind}
\alias{pnbd_nocov_LL_sum}
\alias{pnbd_staticcov_LL_ind}
\alias{pnbd_staticcov_LL_sum}
\title{Pareto/NBD: Log-Likelihood}
\usage{
pnbd_nocov_LL_ind(vLogparams, vX, vT_x, vT_cal)

pnbd_nocov_LL_sum(vLogparams, vX, vT_x, vT_cal)

pnbd_staticcov_LL_ind(vParams, vX, vT_x, vT_cal, mCov_life, mCov_trans)

pnbd_staticcov_LL_sum(vParams, vX, vT_x, vT_cal, mCov_life, mCov_trans)
}
\arguments{
\item{vLogparams}{vector with the Pareto/NBD model parameters log scaled. See Details.}

\item{vX}{Frequency vector of length n counting the numbers of purchases.}

\item{vT_x}{Recency vector of length n.}

\item{vT_cal}{Vector of length n indicating the total number of periods of observation.}

\item{vParams}{vector with the parameters for the Pareto/NBD model and the static covariates. See Details.}

\item{mCov_life}{Matrix containing the covariates data affecting the lifetime process. One column for each covariate.}

\item{mCov_trans}{Matrix containing the covariates data affecting the transaction process. One column for each covariate.}
}
\value{
Returns the respective Log-Likelihood value(s) for the Pareto/NBD model
 with or without covariates.
}
\description{
Calculates the Log-Likelihood values for the Pareto/NBD model with and without covariates.

The function \code{pnbd_nocov_LL_ind} calculates the individual LogLikelihood
values for each customer for the given parameters.

The function \code{pnbd_nocov_LL_sum} calculates the LogLikelihood value summed
across customers for the given parameters.

The function \code{pnbd_staticcov_LL_ind} calculates the individual LogLikelihood
values for each customer for the given parameters and covariates.

The function \code{pnbd_staticcov_LL_sum} calculates the individual LogLikelihood values summed
across customers.
}
\details{
\code{r, alpha_0, s, beta_0} are the model parameters used for estimation.\cr
s: shape parameter of the Gamma distribution for the lifetime process.
The smaller s, the stronger the heterogeneity of customer lifetimes. \cr
beta: scale parameter for the Gamma distribution for the lifetime process. \cr
r: shape parameter of the Gamma distribution of the purchase process.
The smaller r, the stronger the heterogeneity of the purchase process.\cr
alpha: scale parameter of the Gamma distribution of the purchase process.

\code{vParams} is vector with the Pareto/NBD model parameters at log scale,
followed by the parameters for the lifetime covariates at original scale and then
followed by the parameters for the transaction covariates at original scale

\code{mCov_life} is a matrix containing the covariates data of
the time-invariant covariates that affect the lifetime process.
Each column represents a different covariate. For every column, a gamma parameter
needs to added to \code{vParams} at the respective position.

\code{mCov_trans} is a matrix containing the covariates data of
the time-invariant covariates that affect the transaction process.
Each column represents a different covariate. For every column, a gamma parameter
needs to added to \code{vParams} at the respective position.
}
\references{
Fader, Peter S., and Bruce G.S. Hardie (2005). "A Note on Deriving the
 Pareto/NBD Model and Related Expressions.", Web.
 \url{http://www.brucehardie.com/notes/008/}.
}
