% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_related_pairs.R
\name{compile_related_pairs}
\alias{compile_related_pairs}
\title{compile pairwise relationships from the samples}
\usage{
compile_related_pairs(S)
}
\arguments{
\item{S}{a tibble. In the context of this package this tibble is
typically going to often be the
\code{samples} component of the output slurped up from spip with \code{slurp_spip()}.
More generally, it is a tibble that must have the columns:
\itemize{
\item \code{ID}: the id of the sample
\item \code{ancestors}: a list column of the ancestor vectors of each individual
\item \code{relatives}: a list column of the vectors of individual samples (including self)
that each individual is related to.
}}
}
\value{
a tibble with columns \code{id_1} and \code{id_2} for each pair.  Any additional
columns outside of \code{relatives} will be joined with \verb{_1} and
\verb{_2} suffixes.  In a typical run slurped up from spip this leads to the following
columns:
\itemize{
\item \code{id_1}: the id of the first sample of the pair,
\item \code{id_2}: the id of the 2nd sample of the pair,
\item \code{conn_comp}: the index of the connected component to which the pair belongs,
\item \code{dom_relat}: the dominant reltionship that the pair shares,
\item \code{max_hit}: the number of shared ancestors at the level of the dominant relationship
\item \code{dr_hits}: a list column of two-vectors---the number of shared ancestors at the level
of the dominant relationship in the upper and lower quadrants, respectively of the
ancestry match matrix. If the relationship is symmetrical, the two values are the same.
\item \code{upper_member}: for non-symmetrical relationships, a 1 or a 2 indicating which member of the
pair is the one that is typically older (i.e. the uncle in an uncle-nephew relationship), or
NA if the relationship is symmetrical.
\item \code{times_encountered}: the number of times this pair was encountered when processing the
output of the depth first search algorithm that found these pairs.  Not typically used for
downstream analyses.
\item \code{primary_shared_ancestors}: a list columns of two-vectors.  The first element of each is the
the position in the ancestry vector of id_1's primary shared ancestor.  The second element is
the same for id_2.
\item \code{psa_tibs}: like \code{primary_shared_ancestor} but a list column of tibbles.
\item \code{pop_pre_1}, \code{pop_post_1}, \code{pop_dur_1}: the population from which the id_1 individual
was sampled during the prekill, postikill, or during-reproduction sampling episodes,
respectively.  NA for episodes in which the individual was not sampled
\item \code{pop_pre_2}, \code{pop_post_2}, \code{pop_dur_2}: same as above for the id_2 individual.
\item \code{sex_1}: sex of the id_1 individual,
\item \code{sex_2}: sex of the id_2 individual,
\item \code{born_year_1}: birth year of the id_1 individual,
\item \code{born_year_2}: birth year of the id_2 individual,
\item \code{samp_years_list_pre_1}: list column of years during which the id_1 individual was sampled
during the prekill episode.
\item \code{samp_years_list_dur_1}: list column of years during which the id_1 individual was sampled
during reproduction.
\item \code{samp_years_list_post_1}: list column of years during which the id_1 individual was sampled
during the postkill episode.
\item \code{samp_years_list_1}: by default this column is identical to \code{samp_years_list_post_1} and is the
column used in downstream plotting by some functions.  If you want to use a different column,
for example \code{samp_years_list_pre_1} for the downstream plotting, then set the value of
\code{samp_years_list_1} to the same values,
\item \code{samp_years_list_pre_2}, \code{samp_years_list_dur_2}, \code{samp_years_list_post_2}, \code{samp_years_list_2}: same
as above but for individual with id_2,
\item \code{born_pop_1}: index of population in which id_1 was born,
\item \code{ancestors_1}: ancestry vector of id_1,
\item \code{born_pop_2}: index of population in which id_2 was born,
\item \code{ancestors_2}: ancestry vector of id_2,
\item \code{anc_match_matrix}: the ancestry match matrix (a logical matrix) for the pair.
}
}
\description{
Run this on some of the output from \code{slurp_spip()}.
}
\examples{
C <- compile_related_pairs(three_pops_with_mig_slurped_results$samples)
}
