% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PostProcess.R
\name{plot_paraDistribution_byViolinPlots}
\alias{plot_paraDistribution_byViolinPlots}
\title{plot_paraDistribution_byViolinPlots}
\usage{
plot_paraDistribution_byViolinPlots(
  CGNM_result,
  indicesToInclude = NA,
  ParameterNames = NA,
  ReparameterizationDef = NA
)
}
\arguments{
\item{CGNM_result}{(required input) \emph{A list} stores the computational result from Cluster_Gauss_Newton_method() function in CGNM package.}

\item{indicesToInclude}{(default: NA) \emph{A vector of integers} indices to include in the plot (if NA, use indices chosen by the acceptedIndices() function with default setting).}

\item{ParameterNames}{(default: NA) \emph{A vector of strings} the user can supply so that these names are used when making the plot. (Note if it set as NA or vector of incorrect length then the parameters are named as x1, x2, ...)}

\item{ReparameterizationDef}{(default: NA) \emph{A vector of strings} the user can supply definition of reparameterization where each string follows R syntax and also refer to the ith element of the x vector (the input variable to the nonlinear function) as xi (e.g., if the first input variable to the nonlinear function is defined as x1=log10(Ka), then by setting "10^x1" as one of the strings in this vector, you can plot the violin plot of Ka)}
}
\value{
\emph{A ggplot object} including the violin plot, interquartile range and median, minimum and maximum.
}
\description{
Make violin plot to compare the initial distribution and distribition of the accepted approximate minimizers found by the CGNM. Bars in the violin plots indicates the interquartile range. The solid line connects the interquartile ranges of the initial distribution and the distribution of the accepted approximate minimizer at the final iterate.  The blacklines connets the minimums and maximums of the initial distribution and the distribution of the accepted approximate minimizer at the final iterate. The black dots indicate the median.
}
\examples{

model_analytic_function=function(x){

 observation_time=c(0.1,0.2,0.4,0.6,1,2,3,6,12)
 Dose=1000
 F=1

 ka=10^x[1]
 V1=10^x[2]
 CL_2=10^x[3]
 t=observation_time

 Cp=ka*F*Dose/(V1*(ka-CL_2/V1))*(exp(-CL_2/V1*t)-exp(-ka*t))

 log10(Cp)
}

observation=log10(c(4.91, 8.65, 12.4, 18.7, 24.3, 24.5, 18.4, 4.66, 0.238))

CGNM_result=Cluster_Gauss_Newton_method(
nonlinearFunction=model_analytic_function,
targetVector = observation,
initial_lowerRange = c(-2,-2,-2), initial_upperRange =  c(1,2,2),
num_iter = 10, num_minimizersToFind = 100)

a_Indices=acceptedIndices(CGNM_result)
plot_paraDistribution_byViolinPlots(CGNM_result, indicesToInclude=a_Indices)
plot_paraDistribution_byViolinPlots(CGNM_result, indicesToInclude=a_Indices,
     ParameterNames=c("Ka","V1","CL_2"),
     ReparameterizationDef=c("10^x1","10^x2","10^x3"))
}
