% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplotblocks}
\alias{CGGPplotblocks}
\title{CGGP block plot}
\usage{
CGGPplotblocks(CGGP, singleplot = TRUE)
}
\arguments{
\item{CGGP}{CGGP object}

\item{singleplot}{If only two dimensions, should a single plot be made?}
}
\value{
ggplot2 plot
}
\description{
Plot the 2D projections of the blocks of an CGGP object.
}
\examples{
\donttest{
# The first and fourth dimensions are most active and will have greater depth
ss <- CGGPcreate(d=5, batchsize=50)
f <- function(x) {cos(2*pi*x[1]*3) + x[3]*exp(4*x[4])}
ss <- CGGPfit(ss, Y=apply(ss$design, 1, f))
ss <- CGGPappend(CGGP=ss, batchsize=100)
CGGPplotblocks(ss)

mat <- matrix(c(1,1,1,2,2,1,2,2,1,3), ncol=2, byrow=TRUE)
CGGPplotblocks(mat)
}
}
\seealso{
Other CGGP plot functions: \code{\link{CGGPplotcorr}},
  \code{\link{CGGPplotheat}}, \code{\link{CGGPplothist}},
  \code{\link{CGGPplotsamplesneglogpost}},
  \code{\link{CGGPplotslice}}, \code{\link{CGGPplottheta}},
  \code{\link{CGGPplotvariogram}},
  \code{\link{CGGPvalplot}}
}
\concept{CGGP plot functions}
