% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_fit_fs.R
\name{CGGPfit}
\alias{CGGPfit}
\title{Update CGGP model given data}
\usage{
CGGPfit(CGGP, Y, Xs = NULL, Ys = NULL,
  theta0 = pmax(pmin(CGGP$thetaMAP, 0.8), -0.8),
  HandlingSuppData = CGGP$HandlingSuppData,
  separateoutputparameterdimensions = is.matrix(CGGP$thetaMAP),
  set_thetaMAP_to, corr, Ynew)
}
\arguments{
\item{CGGP}{Sparse grid objects}

\item{Y}{Output values calculated at CGGP$design}

\item{Xs}{Supplemental X matrix}

\item{Ys}{Supplemental Y values}

\item{theta0}{Initial theta}

\item{HandlingSuppData}{How should supplementary data be handled?
* Correct: full likelihood with grid and supplemental data
* Only: only use supplemental data
* Ignore: ignore supplemental data}

\item{separateoutputparameterdimensions}{If multiple output dimensions,
should separate parameters be fit to each dimension?}

\item{set_thetaMAP_to}{Value for thetaMAP to be set to}

\item{corr}{Will update correlation function, if left missing it will be
same as last time.}

\item{Ynew}{Values of `CGGP$design_unevaluated`}
}
\value{
Updated CGGP object fit to data given
}
\description{
This function will update the GP parameters for a CGGP design.
}
\examples{
cg <- CGGPcreate(d=3, batchsize=100)
y <- apply(cg$design, 1, function(x){x[1]+x[2]^2})
cg <- CGGPfit(CGGP=cg, Y=y)
}
\seealso{
Other CGGP core functions: \code{\link{CGGPappend}},
  \code{\link{CGGPcreate}}, \code{\link{predict.CGGP}}
}
\concept{CGGP core functions}
