% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulnerability.R
\docType{methods}
\name{vulnerability}
\alias{vulnerability}
\alias{vulnerability,cnfa,departure-method}
\title{Climatic vulnerability}
\usage{
vulnerability(cnfa, dep, method = "geometric", w, parallel = FALSE, n = 1,
  filename = "", ...)

\S4method{vulnerability}{cnfa,departure}(cnfa, dep, method = "geometric", w,
  parallel = FALSE, n = 1, filename = "", ...)
}
\arguments{
\item{cnfa}{Object of class \code{cnfa}}

\item{dep}{Object of class \code{departure}}

\item{method}{character. What type of mean should be used to combine sensitivity
and exposure. Choices are "arithmetic" and "geometric"}

\item{w}{numeric. Optional vector of length two specifying the relative weights of
sensitivity and exposure. See Details}

\item{parallel}{logical. If \code{TRUE} then multiple cores are utilized}

\item{n}{numeric. Number of cores to use for calculation}

\item{filename}{character. Output filename (optional)}

\item{...}{Additional arguments for file writing as for \code{\link[raster]{writeRaster}}}
}
\value{
Returns an S4 object of class \code{vulnerability} with the following slots:
\describe{
  \item{call}{Original function call}
  \item{vf}{Vulnerability factor. Vector of length p that describes the amount of
   vulnerability in each climate variable}
  \item{vulnerability}{Magnitude of the vulnerability factor}
  \item{ras}{RasterLayer of climate vulnerability}
  \item{weights}{Raster layer of weights used for departure calculation}
}
}
\description{
Calculates the climatic vulnerability of a species using a \code{cnfa} and
\code{departure} object.
}
\details{
The values of the vulnerability raster are calculated by combining the sensitivity
\eqn{\sigma} and the exposure \eqn{\epsilon}. If \code{method = "arithmetic"},
they will be combined as

  \eqn{\nu = (w_1\sigma + w_2\epsilon) / (\sum_i w_i).}

If \code{method = "geometric"}, they will be combined as

  \eqn{\nu = \sqrt(\sigma * \epsilon).}
}
\examples{
mod1 <- cnfa(x = climdat.hist, s.dat = ABPR, field = "CODE")
dep <- departure(x = climdat.hist, y = climdat.fut, s.dat = ABPR)
vuln <- vulnerability(cnfa = mod1, dep = dep)

}
\seealso{
\code{\link{departure}}
}
