% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_processing.R
\name{automatic_NLP_processor}
\alias{automatic_NLP_processor}
\title{Process NLP Annotations on the Current Patient Cohort}
\usage{
automatic_NLP_processor(
  patient_vect = NA,
  text_format = "latin1",
  nlp_engine = "udpipe",
  uri_fun = mongo_uri_standard,
  user,
  password,
  host,
  port,
  database,
  max_n_grams_length = 7,
  negex_depth = 6,
  select_cores = NA,
  URL = NA
)
}
\arguments{
\item{patient_vect}{Vector of patient ID's. Default is NA, in which case all available patient records will undergo NLP annotation.}

\item{text_format}{Text format for NLP engine.}

\item{nlp_engine}{Which NLP engine should be used? UDPipe is the only one supported for now.}

\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{max_n_grams_length}{Maximum length of tokens for matching with UMLS concept unique identifiers (CUI's). Shorter values will result in faster processing. If 0 is chosen, UMLS CUI tags will not be provided.}

\item{negex_depth}{Maximum distance between negation item and token to negate. Shorter distances will result in decreased sensitivity but increased specificity for negation.}

\item{select_cores}{How many CPU cores should be used for parallel processing? Max allowed is total number of cores minus one. If 1 is entered, parallel processing will not be used.}

\item{URL}{UDPipe model URL.}
}
\value{
{
Confirmation that requested operation was completed, or error message if attempt failed.
}
}
\description{
Accepts a list of patient ID's or alternatively can perform NLP annotations on all available patients in the database.
}
\examples{
\dontrun{
automatic_NLP_processor(patient_vect = NA, text_format = 'latin1', nlp_engine = 'udpipe',
URL = 'models/english-ewt-ud-2.4-190531.udpipe', uri_fun = mongo_uri_standard, user = 'John',
password = 'db_password_1234', host = 'server1234', port = NA, database = 'TEST_PROJECT',
max_n_grams_length = 7, negex_depth = 6, select_cores = 1)
}
}
