% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDROM.R
\name{CDROM}
\alias{CDROM}
\title{CDROM: Classification of Duplicate gene RetentiOn Mechanisms}
\usage{
CDROM(dupFile, singleFile, exprFile1, exprFile2, out = "out", Ediv,
  PC = FALSE, head1 = TRUE, head2 = TRUE, head3 = TRUE, head4 = TRUE,
  legend = "topleft")
}
\arguments{
\item{dupFile}{a tab-separated file containing duplicate gene pairs and their orthologs (three gene IDs per line).}

\item{singleFile}{a tab-separated file containing orthologous single-copy genes (two gene IDs per line).}

\item{exprFile1}{a tab-separated file containing gene expression levels for all genes in species 1 (one gene ID and its expression levels per line).}

\item{exprFile2}{a tab-separated file containing gene expression levels for all genes in species 2 (one gene ID and its expression levels per line).}

\item{out}{the prefix to be used in the names of the three output files. Defaults to 'out'.}

\item{Ediv}{the divergence cutoff to be used in classifications. Defaults to semi-interquartile range of the median (SIQR).}

\item{PC}{a logical value indicating whether parent and child copies are separated in dupFile. Defaults to FALSE.}

\item{head1}{a logical value indicating whether exprFile1 contains the names of its variables as the first line. Defaults to TRUE.}

\item{head2}{a logical value indicating whether exprFile2 contains the names of its variables as the first line. Defaults to TRUE.}

\item{head3}{a logical value indicating whether dupFile contains the names of its variables as the first line. Defaults to TRUE.}

\item{head4}{a logical value indicating whether singleFile contains the names of its variables as the first line. Defaults to TRUE.}

\item{legend}{a keyword indicating the position of the legend in the output plot. Options are 'topright' and 'topleft'. Defaults to 'topleft'.}
}
\value{
A table with the classifications of all duplicate gene pairs.

A table with counts of classifications with five Ediv values.

A plot showing distributions of all Euclidean distances and the position of Ediv.
}
\description{
Classification is based on the recently developed phylogenetic approach by Assis and Bachtrog (2013). The method classifies the evolutionary mechanisms
retaining pairs of duplicate genes (conservation, neofunctionalization, subfunctionalization, or specialization) by comparing gene expression profiles of 
duplicate genes in one species to those of their single-copy ancestral genes in a sister species.
}
\examples{
CDROM(dupFile=system.file("extdata","human_chicken_dups.txt",package="CDROM"),
singleFile=system.file("extdata","human_chicken_singles.txt",package="CDROM"),
exprFile1=system.file("extdata","human_expr.txt",package="CDROM"),
exprFile2=system.file("extdata","chicken_expr.txt",package="CDROM"))
}
\author{
Brent Perry <brp5173@psu.edu>, Raquel Assis <rassis@psu.edu>
}
\references{
[1] Assis R and Bachtrog D. Neofunctionalization of young duplicate genes in Drosophila. Proc. Natl. Acad. Sci. USA. 110: 17409-17414 (2013).
}
\keyword{duplication,}
\keyword{gene}
\keyword{neofunctionalization,}
\keyword{subfunctionalization}

