% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuyseTTEM.R
\name{predict.BuyseTTEM}
\alias{predict.BuyseTTEM}
\title{Prediction with Time to Event Model}
\usage{
\method{predict}{BuyseTTEM}(object, time, treatment, strata, cause = 1, iid = FALSE, ...)
}
\arguments{
\item{object}{time to event model.}

\item{time}{[numeric vector] time at which to evaluate the cif/survival.}

\item{treatment}{[character/integer] Treatment or index of the treatment group.}

\item{strata}{[character/integer] Strata or index of the strata.}

\item{cause}{[integer] The cause relative to which the cif will be evaluated.}

\item{iid}{[logical] Should the influence function associated with the cif/survival be output?}

\item{...}{not used, for compatibility with the generic method.}
}
\value{
a list containing the survival (element \code{survival}) or the cumulative incidence function (element \code{cif}),
and possible standard errors (element \code{.se}) and influence function (element \code{.iid}).
}
\description{
Evaluate the cumulative incidence function (cif) / survival in one of the treatment groups.
}
\keyword{methods}
